/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.glassfish.embeddable.GlassFishVariable;

public final class GFLauncherUtils {
    private GFLauncherUtils() {
    }

    public static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean safeExists(File f) {
        return f != null && f.exists();
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.isDirectory();
    }

    public static File getInstallDir() {
        try {
            return GFLauncherUtils.resolveInstallDir();
        }
        catch (IOException | URISyntaxException e) {
            throw new Error("Cannot resolve install root!", e);
        }
    }

    public static boolean isWindows() {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.length() <= 0) {
            return false;
        }
        return (osname = osname.toLowerCase(Locale.ENGLISH)).indexOf("windows") >= 0;
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.isEmpty() || token == null || token.isEmpty()) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        Object ret = s.substring(0, index);
        ret = (String)ret + replace;
        ret = (String)ret + s.substring(index + tokenLength);
        return ret;
    }

    public static boolean isRelativePath(String path) {
        if (!GFLauncherUtils.ok(path)) {
            return false;
        }
        if (path.startsWith(".")) {
            return true;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        return path.indexOf("\\.") >= 0;
    }

    public static List<File> stringToFiles(String cp) {
        ArrayList<File> list = new ArrayList<File>();
        if (GFLauncherUtils.ok(cp)) {
            String[] ss;
            cp = SmartFile.sanitizePaths(cp);
            for (String s : ss = cp.split(File.pathSeparator)) {
                list.add(new File(s));
            }
        }
        return list;
    }

    public static String fileListToPathString(List<File> files) {
        StringBuilder sb = new StringBuilder();
        boolean firstFile = true;
        for (File f : files) {
            if (firstFile) {
                firstFile = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getPath().replace('\\', '/'));
        }
        return sb.toString();
    }

    private static File resolveInstallDir() throws IOException, URISyntaxException {
        String sys = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName());
        if (sys != null) {
            return GFLauncherUtils.toValidDirectory(sys);
        }
        String env = System.getenv(GlassFishVariable.INSTALL_ROOT.getEnvName());
        if (env != null) {
            return GFLauncherUtils.toValidDirectory(env);
        }
        return new File(GFLauncherUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalFile().getParentFile().getParentFile();
    }

    private static File toValidDirectory(String value) throws IOException {
        File file = new File(value).toPath().normalize().toFile();
        if (!file.isAbsolute()) {
            throw new IOException("The path to install root is not an absolute path: " + String.valueOf(file));
        }
        File canonical = file.getCanonicalFile();
        if (!canonical.isDirectory()) {
            throw new IOException("The path to install root is not a directory: " + String.valueOf(canonical));
        }
        return canonical;
    }
}

