/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.WorkDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class LastRunInfo {
    private String configName;
    private long startTime;
    private long finishTime;
    private ArrayList testURLs;
    private static final String FILENAME = "lastRun.txt";
    private static final String START = "startTime";
    private static final String FINISH = "finishTime";
    private static final String CONFIG = "configName";
    private static final String TEST_URLS = "testURLs";
    private static final String SEP = " ";

    private LastRunInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LastRunInfo(WorkDirectory wd) throws IOException {
        this();
        Properties p;
        FileInputStream in = null;
        try {
            in = new FileInputStream(wd.getSystemFile(FILENAME));
            p = new Properties();
            p.load(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        String val = p.getProperty(START);
        try {
            this.startTime = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        val = p.getProperty(FINISH);
        try {
            this.finishTime = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.configName = p.getProperty(CONFIG);
        this.testURLs = LastRunInfo.split(p.getProperty(TEST_URLS));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Date getStartDate() {
        return new Date(this.startTime);
    }

    public Date getFinishDate() {
        return new Date(this.finishTime);
    }

    public String getConfigName() {
        return this.configName;
    }

    public ArrayList getTestURLs() {
        return this.testURLs;
    }

    private static String join(ArrayList list) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            sb.append(SEP);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static ArrayList split(String joined) {
        ArrayList<String> list = new ArrayList<String>();
        if (joined == null || joined.trim().length() == 0) {
            return list;
        }
        int begin = 0;
        int end = joined.indexOf(SEP);
        while (end >= 0) {
            list.add(joined.substring(begin, end));
            begin = end + SEP.length();
            end = joined.indexOf(SEP, begin);
        }
        list.add(joined.substring(begin));
        return list;
    }

    public static LastRunInfo readInfo(WorkDirectory wd) throws IOException {
        return new LastRunInfo(wd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInfo(WorkDirectory workdir, long start, long stop, String config, ArrayList testURLs) throws IOException {
        Properties p = new Properties();
        p.setProperty(CONFIG, config);
        p.setProperty(START, Long.toString(start));
        p.setProperty(FINISH, Long.toString(stop));
        p.setProperty(TEST_URLS, LastRunInfo.join(testURLs));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(workdir.getSystemFile(FILENAME));
            p.store(out, "Last test run info");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

