/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.jsonptypes;

import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonArrayContainer;
import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonNumberContainer;
import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonObjectContainer;
import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonStringContainer;
import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonStructureContainer;
import ee.jakarta.tck.json.bind.defaultmapping.jsonptypes.model.JsonValueContainer;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JSONPTypesMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testJsonObjectMapping() {
        final JsonObject instance = Json.createObjectBuilder().add("jsonObjectInstance", Json.createObjectBuilder().add("innerInstance", "Inner Test String")).add("jsonArrayInstance", Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2"))).add("jsonStringInstance", "Test String").add("jsonNumberInstance", Integer.MAX_VALUE).add("jsonTrueInstance", JsonValue.TRUE).add("jsonFalseInstance", JsonValue.FALSE).add("jsonNullInstance", JsonValue.NULL).build();
        String jsonString = this.jsonb.toJson((Object)new JsonObjectContainer(){
            {
                this.setInstance(instance);
            }
        });
        String validationRegexp = "\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"jsonObjectInstance\"\\s*:\\s*\\{\\s*\"innerInstance\"\\s*:\\s*\"Inner Test String\"\\s*\\}\\s*,\\s*\"jsonArrayInstance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*,\\s*\"jsonStringInstance\"\\s*:\\s*\"Test String\"\\s*,\\s*\"jsonNumberInstance\"\\s*:\\s*2147483647\\s*,\\s*\"jsonTrueInstance\"\\s*:\\s*true\\s*,\\s*\"jsonFalseInstance\"\\s*:\\s*false\\s*,\\s*\"jsonNullInstance\"\\s*:\\s*null\\s*\\}\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonObject attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"instance\" : { \"jsonObjectInstance\" : { \"innerInstance\" : \"Inner Test String\" }, \"jsonArrayInstance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ], \"jsonStringInstance\" : \"Test String\", \"jsonNumberInstance\" : 2147483647, \"jsonTrueInstance\" : true, \"jsonFalseInstance\" : false, \"jsonNullInstance\" : null } }";
        JsonObjectContainer unmarshalledObject = (JsonObjectContainer)this.jsonb.fromJson(toDeserialize, JsonObjectContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonObject attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testEmptyJsonObjectMapping() {
        final JsonObject instance = Json.createObjectBuilder().build();
        String jsonString = this.jsonb.toJson((Object)new JsonObjectContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with empty JsonObject attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\\}\\s*\\}"));
        JsonObjectContainer unmarshalledObject = (JsonObjectContainer)this.jsonb.fromJson("{ \"instance\" : { } }", JsonObjectContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with empty JsonObject attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonArrayMapping() {
        final JsonArray instance = Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2")).build();
        String jsonString = this.jsonb.toJson((Object)new JsonArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        String validationPattern = "\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonArray attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        String toDeserialize = "{ \"instance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ] }";
        JsonArrayContainer unmarshalledObject = (JsonArrayContainer)this.jsonb.fromJson(toDeserialize, JsonArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonArray attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testEmptyJsonArrayMapping() {
        final JsonArray instance = Json.createArrayBuilder().build();
        String jsonString = this.jsonb.toJson((Object)new JsonArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with empty JsonArray attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\]\\s*\\}"));
        JsonArrayContainer unmarshalledObject = (JsonArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ ] }", JsonArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with empty JsonArray attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonObjectStructureMapping() {
        JsonObject instance = Json.createObjectBuilder().add("jsonObjectInstance", Json.createObjectBuilder().add("innerInstance", "Inner Test String")).add("jsonArrayInstance", Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2"))).add("jsonStringInstance", "Test String").add("jsonNumberInstance", Integer.MAX_VALUE).add("jsonTrueInstance", JsonValue.TRUE).add("jsonFalseInstance", JsonValue.FALSE).add("jsonNullInstance", JsonValue.NULL).build();
        String jsonString = this.jsonb.toJson((Object)new JsonStructureContainer((JsonStructure)instance){
            final /* synthetic */ JsonStructure val$instance;
            {
                this.val$instance = jsonStructure;
                this.setInstance(this.val$instance);
            }
        });
        String validationRegexp = "\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"jsonObjectInstance\"\\s*:\\s*\\{\\s*\"innerInstance\"\\s*:\\s*\"Inner Test String\"\\s*\\}\\s*,\\s*\"jsonArrayInstance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*,\\s*\"jsonStringInstance\"\\s*:\\s*\"Test String\"\\s*,\\s*\"jsonNumberInstance\"\\s*:\\s*2147483647\\s*,\\s*\"jsonTrueInstance\"\\s*:\\s*true\\s*,\\s*\"jsonFalseInstance\"\\s*:\\s*false\\s*,\\s*\"jsonNullInstance\"\\s*:\\s*null\\s*\\}\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonObject JsonStructure attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"instance\" : { \"jsonObjectInstance\" : { \"innerInstance\" : \"Inner Test String\" }, \"jsonArrayInstance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ], \"jsonStringInstance\" : \"Test String\", \"jsonNumberInstance\" : 2147483647, \"jsonTrueInstance\" : true, \"jsonFalseInstance\" : false, \"jsonNullInstance\" : null } }";
        JsonStructureContainer unmarshalledObject = (JsonStructureContainer)this.jsonb.fromJson(toDeserialize, JsonStructureContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonObject JsonStructure attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonArrayStructureMapping() {
        JsonArray instance = Json.createArrayBuilder().add(Json.createObjectBuilder().add("arrayInstance1", "Array Test String 1")).add(Json.createObjectBuilder().add("arrayInstance2", "Array Test String 2")).build();
        String jsonString = this.jsonb.toJson((Object)new JsonStructureContainer((JsonStructure)instance){
            final /* synthetic */ JsonStructure val$instance;
            {
                this.val$instance = jsonStructure;
                this.setInstance(this.val$instance);
            }
        });
        String validationRegexp = "\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"arrayInstance1\"\\s*:\\s*\"Array Test String 1\"\\s*\\}\\s*,\\s*\\{\\s*\"arrayInstance2\"\\s*:\\s*\"Array Test String 2\"\\s*\\}\\s*\\]\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonArray JsonStructure attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"instance\" : [ { \"arrayInstance1\" : \"Array Test String 1\" }, { \"arrayInstance2\" : \"Array Test String 2\" } ] }";
        JsonStructureContainer unmarshalledObject = (JsonStructureContainer)this.jsonb.fromJson(toDeserialize, JsonStructureContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonArray JsonStructure attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonValueMapping() {
        JsonObject instance = Json.createObjectBuilder().add("stringInstance", "Test String").build();
        String jsonString = this.jsonb.toJson((Object)new JsonValueContainer((JsonValue)instance){
            final /* synthetic */ JsonValue val$instance;
            {
                this.val$instance = jsonValue;
                this.setInstance(this.val$instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonValue attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"stringInstance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}"));
        JsonValueContainer unmarshalledObject = (JsonValueContainer)this.jsonb.fromJson("{ \"instance\" : { \"stringInstance\" : \"Test String\" } }", JsonValueContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonValue attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonStringMapping() {
        final JsonString instance = Json.createValue((String)"Test String");
        String jsonString = this.jsonb.toJson((Object)new JsonStringContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonString attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        JsonStringContainer unmarshalledObject = (JsonStringContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", JsonStringContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonString attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testJsonNumberMapping() {
        final JsonNumber instance = Json.createValue((int)0);
        String jsonString = this.jsonb.toJson((Object)new JsonNumberContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with JsonNumber attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*0\\s*\\}"));
        JsonNumberContainer unmarshalledObject = (JsonNumberContainer)this.jsonb.fromJson("{ \"instance\" : 0 }", JsonNumberContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with JsonNumber attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testNullDeserializedToJsonValueNull() {
        JsonValueContainer unmarshalledValue = (JsonValueContainer)this.jsonb.fromJson("{ \"instance\" : null }", JsonValueContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal null value to the JsonValue.NULL", (Object)unmarshalledValue.getInstance(), (Matcher)Matchers.is((Object)JsonValue.NULL));
        unmarshalledValue = (JsonValueContainer)this.jsonb.fromJson("{}", JsonValueContainer.class);
        MatcherAssert.assertThat((String)"No value should have been deserialized.", (Object)unmarshalledValue.getInstance(), (Matcher)Matchers.nullValue());
    }
}

