/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.app.J2eeEar;
import com.sun.ant.taskdefs.client.ClientJar;
import com.sun.ant.taskdefs.common.ArchiveInfo;
import com.sun.ant.taskdefs.common.ContainerPackage;
import com.sun.ant.taskdefs.common.Packager;
import com.sun.ant.taskdefs.common.TaskUtil;
import com.sun.ant.taskdefs.ejb.EJBJar;
import com.sun.ant.taskdefs.web.WebWar;
import com.sun.ant.types.Support;
import com.sun.ts.lib.harness.VehicleVerifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.taskdefs.Touch;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;

public class TSVehicles
extends Task {
    private static String runnerClasses = "com/sun/ts/tests/common/vehicle/VehicleRunnerFactory.class, com/sun/ts/tests/common/vehicle/VehicleRunnable.class";
    static String pkgName = "com" + File.separator + "sun" + File.separator + "ts";
    static String j2eeHome;
    static String vehicleDir;
    private File srcDir;
    private File distDir;
    private String name;
    private File manifest;
    private String mainclass;
    private String testClientClass;
    private String extraJars;
    private List supports = new ArrayList();
    private String ejbName;
    private String servletName;
    private String jspName;
    private String appclientName;
    private List contentFileSets = new ArrayList();
    static String ejbXml;
    static String ejbClientXml;
    static String servletXml;
    static String jspXml;
    static String appclientXml;
    private static FileSet defaultJspContent;
    private static File defaultJspContentDir;
    private Set neededXml = new HashSet(19);
    private Map neededFilters = new HashMap(11);
    private String extra4Ejb = "";
    private String extra4Servlet = "";
    private String extra4Jsp = "";
    private String extra4Appclient = "";
    private String mainclassAsDir;
    private String testClientClassAsDir;
    public String autocheckexcludes;
    private boolean separateRuntimeFiles;
    boolean isStandAlone;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setAutocheckexcludes(String s) {
        this.autocheckexcludes = s;
    }

    private void initStatic() {
        if (vehicleDir == null || vehicleDir.length() == 0) {
            vehicleDir = TSBuildListener.tsHome + File.separator + "src" + File.separator + pkgName + File.separator + "tests" + File.separator + "common" + File.separator + "vehicle";
        }
        if (defaultJspContentDir == null) {
            defaultJspContentDir = new File(vehicleDir + File.separator + "jsp" + File.separator + "contentRoot");
        }
        if (defaultJspContent == null) {
            defaultJspContent = new FileSet();
            defaultJspContent.setDir(defaultJspContentDir);
            defaultJspContent.setIncludes("*.html, *.jsp");
        }
    }

    public void myinit() throws BuildException {
        this.initStatic();
        this.srcDir = TaskUtil.getCurrentSrcDir(this.project);
        this.distDir = TaskUtil.getFullDistDir(this.srcDir, this.project);
        if (ContainerPackage.buildLevel == 0) {
            ContainerPackage.buildLevel = (byte)3;
            String sLevel = this.project.getProperty("build.level");
            if (sLevel != null) {
                try {
                    ContainerPackage.buildLevel = Byte.parseByte(sLevel);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void execute() throws BuildException {
        int i;
        this.myinit();
        if (!TSBuildListener.vehiclesBuilt) {
            this.compileVehicles();
        }
        if (ContainerPackage.buildLevel == 1) {
            return;
        }
        this.initAppName();
        this.mainclassAsDir = this.mainclass.replace('.', '/');
        this.testClientClassAsDir = this.testClientClass.replace('.', '/');
        String[] vehicles = this.getVehicles(this.srcDir);
        if (vehicles.length == 0) {
            throw new BuildException("No vehicle specified for this directory in src/vehicle.properties.");
        }
        this.log("vehicles=" + Arrays.asList(vehicles).toString());
        for (int i2 = 0; i2 < vehicles.length; ++i2) {
            if (vehicles[i2].equals("ejb")) {
                this.neededXml.add(ejbXml + ".xml");
                this.neededXml.add(ejbXml + ".runtime.xml");
                this.neededXml.add(ejbClientXml + ".xml");
                this.neededXml.add(ejbClientXml + ".runtime.xml");
                this.neededFilters.put("jndi-name>com_sun_ts_tests_common_vehicle_ejb_EJBVehicle", "jndi-name>" + this.ejbName);
                this.neededFilters.put("display-name>ejb_vehicle_client", "display-name>" + this.ejbName + "_client");
                continue;
            }
            if (vehicles[i2].equals("servlet")) {
                this.neededXml.add(servletXml + ".xml");
                this.neededXml.add(servletXml + ".runtime.xml");
                this.neededFilters.put("context-root>servlet_vehicle", "context-root>" + this.servletName);
                this.neededFilters.put("display-name>servlet_vehicle", "display-name>" + this.servletName);
                this.neededFilters.put("<web-uri>servlet_vehicle_web.war</web-uri>", "<web-uri>" + this.servletName + "_web.war</web-uri>");
                continue;
            }
            if (vehicles[i2].equals("jsp")) {
                this.neededXml.add(jspXml + ".xml");
                this.neededXml.add(jspXml + ".runtime.xml");
                this.neededFilters.put("context-root>jsp_vehicle", "context-root>" + this.jspName);
                this.neededFilters.put("display-name>jsp_vehicle", "display-name>" + this.jspName);
                this.neededFilters.put("<web-uri>jsp_vehicle_web.war</web-uri>", "<web-uri>" + this.jspName + "_web.war</web-uri>");
                continue;
            }
            if (vehicles[i2].equals("appclient")) {
                this.neededXml.add(appclientXml + ".xml");
                this.neededXml.add(appclientXml + ".runtime.xml");
                this.neededFilters.put("display-name>appclient_vehicle_client", "display-name>" + this.appclientName + "_client");
                continue;
            }
            this.isStandAlone = true;
        }
        File[] allRuntimeFiles = this.srcDir.listFiles(ArchiveInfo.runtimeFileFilter);
        if (allRuntimeFiles != null) {
            for (i = 0; i < allRuntimeFiles.length; ++i) {
                String fileName = allRuntimeFiles[i].getName();
                this.neededXml.add(fileName);
                if (this.separateRuntimeFiles || !fileName.endsWith("ejb_vehicle_ejb.runtime.xml") && !fileName.endsWith("ejb_vehicle_client.runtime.xml") && !fileName.endsWith("servlet_vehicle_web.runtime.xml") && !fileName.endsWith("jsp_vehicle_web.runtime.xml") && !fileName.endsWith("appclient_vehicle_appclient.runtime.xml")) continue;
                this.separateRuntimeFiles = true;
            }
        }
        this.copyAndReplace(vehicles);
        for (i = 0; i < vehicles.length; ++i) {
            if (vehicles[i].equals("ejb")) {
                this.doEjb();
                continue;
            }
            if (vehicles[i].equals("servlet")) {
                this.doServlet();
                continue;
            }
            if (vehicles[i].equals("jsp")) {
                this.doJsp();
                continue;
            }
            if (!vehicles[i].equals("appclient")) continue;
            this.doAppclient();
        }
        TSBuildListener.setAlreadyMadeup(false);
    }

    private void doEjb() throws BuildException {
        File dfile = new File(this.distDir, this.name + "_" + ejbXml + ".xml");
        EJBJar ejbJarTask = new EJBJar();
        ejbJarTask.setProject(this.project);
        ejbJarTask.init();
        ejbJarTask.setTaskName("ejb-jar");
        ejbJarTask.setName(this.ejbName);
        ejbJarTask.setSrcdir(TSBuildListener.fClassDir);
        ejbJarTask.setDescriptor(dfile);
        if (this.manifest != null) {
            ejbJarTask.setManifest(this.manifest);
        }
        if (this.autocheckexcludes != null) {
            ejbJarTask.setAutocheckexcludes(this.autocheckexcludes);
        }
        Support mainClass = new Support();
        mainClass.setDir(TSBuildListener.fClassDir);
        mainClass.setIncludes(this.testClientClassAsDir + ".class, " + runnerClasses);
        ejbJarTask.addSupport(mainClass);
        this.handleSupport(ejbJarTask);
        ejbJarTask.perform();
        this.addFilesToArchive(this.ejbName + "_ejb.jar");
        TSBuildListener.setAlreadyMadeup(true);
        dfile = new File(this.distDir, this.name + "_" + ejbClientXml + ".xml");
        ClientJar clientJarTask = new ClientJar();
        clientJarTask.setProject(this.project);
        clientJarTask.init();
        clientJarTask.setTaskName("clientjar");
        clientJarTask.setName(this.ejbName);
        clientJarTask.setSrcdir(TSBuildListener.fClassDir);
        clientJarTask.setDescriptor(dfile);
        clientJarTask.includeLastJarredFiles(true);
        if (this.manifest != null) {
            clientJarTask.setManifest(this.manifest);
        }
        if (this.autocheckexcludes != null) {
            clientJarTask.setAutocheckexcludes(this.autocheckexcludes);
        }
        clientJarTask.setMainClass(this.mainclass);
        Support vehicleClasses = new Support();
        vehicleClasses.setDir(TSBuildListener.fClassDir);
        vehicleClasses.setIncludes("com/sun/ts/tests/common/vehicle/ejb/EJBVehicleHome.class, com/sun/ts/tests/common/vehicle/ejb/EJBVehicleRemote.class, com/sun/ts/tests/common/vehicle/ejb/EJBVehicleRunner.class, " + runnerClasses);
        clientJarTask.addSupport(vehicleClasses);
        this.handleSupport(clientJarTask);
        clientJarTask.perform();
        this.addFilesToArchive(this.ejbName + "_client.jar");
        String toInclude = null;
        toInclude = this.extra4Ejb.length() > 0 ? (this.extra4Ejb.endsWith(",") ? this.extra4Ejb + "*_ejb_vehicle*.jar" : "*_ejb_vehicle*.jar," + this.extra4Ejb) : "*_ejb_vehicle*.jar";
        this.makeEar("_ejb_vehicle", toInclude);
    }

    private void doServlet() throws BuildException {
        File dfile = new File(this.distDir, this.name + "_" + servletXml + ".xml");
        WebWar webWarTask = new WebWar();
        webWarTask.setProject(this.project);
        webWarTask.init();
        webWarTask.setTaskName("webwar");
        webWarTask.setName(this.servletName);
        webWarTask.setSrcdir(TSBuildListener.fClassDir);
        webWarTask.setDescriptor(dfile);
        if (this.manifest != null) {
            webWarTask.setManifest(this.manifest);
        }
        if (this.autocheckexcludes != null) {
            webWarTask.setAutocheckexcludes(this.autocheckexcludes);
        }
        Support support = new Support();
        support.setDir(TSBuildListener.fClassDir);
        support.setIncludes(this.testClientClassAsDir + ".class, com/sun/ts/tests/common/vehicle/servlet/ServletVehicleRunner.class," + runnerClasses);
        webWarTask.addSupport(support);
        this.handleSupport(webWarTask);
        webWarTask.addAllContentFileSets(this.contentFileSets);
        webWarTask.perform();
        this.addFilesToArchive(this.servletName + "_web.war");
        TSBuildListener.setAlreadyMadeup(true);
        String toInclude = null;
        toInclude = this.extra4Servlet.length() > 0 ? (this.extra4Servlet.endsWith(",") ? this.extra4Servlet + "*_servlet_vehicle*.war" : "*_servlet_vehicle*.war," + this.extra4Servlet) : "*_servlet_vehicle*.war";
        this.makeEar("_servlet_vehicle", toInclude);
    }

    private void doJsp() throws BuildException {
        File dfile = new File(this.distDir, this.name + "_" + jspXml + ".xml");
        WebWar webWarTask = new WebWar();
        webWarTask.setProject(this.project);
        webWarTask.init();
        webWarTask.setTaskName("webwar");
        webWarTask.setName(this.jspName);
        webWarTask.setSrcdir(TSBuildListener.fClassDir);
        webWarTask.setDescriptor(dfile);
        if (this.manifest != null) {
            webWarTask.setManifest(this.manifest);
        }
        if (this.autocheckexcludes != null) {
            webWarTask.setAutocheckexcludes(this.autocheckexcludes);
        }
        Support support = new Support();
        support.setDir(TSBuildListener.fClassDir);
        support.setIncludes(this.testClientClassAsDir + ".class, com/sun/ts/tests/common/vehicle/jsp/JSPVehicleRunner.class," + runnerClasses);
        webWarTask.addSupport(support);
        webWarTask.addcontentFileset(defaultJspContent);
        webWarTask.addAllContentFileSets(this.contentFileSets);
        this.handleSupport(webWarTask);
        webWarTask.perform();
        this.addFilesToArchive(this.jspName + "_web.war");
        TSBuildListener.setAlreadyMadeup(true);
        String toInclude = null;
        toInclude = this.extra4Jsp.length() > 0 ? (this.extra4Jsp.endsWith(",") ? this.extra4Jsp + "*_jsp_vehicle*.war" : "*_jsp_vehicle*.war," + this.extra4Jsp) : "*_jsp_vehicle*.war";
        this.makeEar("_jsp_vehicle", toInclude);
    }

    private void doAppclient() throws BuildException {
        File dfile = new File(this.distDir, this.name + "_" + appclientXml + ".xml");
        ClientJar clientJarTask = new ClientJar();
        clientJarTask.setProject(this.project);
        clientJarTask.init();
        clientJarTask.setTaskName("clientjar");
        clientJarTask.setName(this.appclientName);
        clientJarTask.setSrcdir(TSBuildListener.fClassDir);
        clientJarTask.setDescriptor(dfile);
        if (this.manifest != null) {
            clientJarTask.setManifest(this.manifest);
        }
        if (this.autocheckexcludes != null) {
            clientJarTask.setAutocheckexcludes(this.autocheckexcludes);
        }
        clientJarTask.setMainClass(this.mainclass);
        Support vehicleClasses = new Support();
        vehicleClasses.setDir(TSBuildListener.fClassDir);
        vehicleClasses.setIncludes(this.testClientClassAsDir + ".class," + runnerClasses + ",com/sun/ts/tests/common/vehicle/EmptyVehicleRunner.class");
        clientJarTask.addSupport(vehicleClasses);
        this.handleSupport(clientJarTask);
        clientJarTask.perform();
        String appclientJarName = this.appclientName + "_client.jar";
        this.addFilesToArchive(appclientJarName);
        TSBuildListener.setAlreadyMadeup(true);
        String toInclude = null;
        toInclude = this.extra4Appclient.length() > 0 ? (this.extra4Appclient.endsWith(",") ? this.extra4Appclient + "*_appclient_vehicle*.jar" : "*_appclient_vehicle*.jar," + this.extra4Appclient) : "*_appclient_vehicle*.jar";
        this.makeEar("_appclient_vehicle", toInclude);
    }

    private void compileVehicles() {
        Javac compiler = new Javac();
        compiler.setProject(this.project);
        compiler.init();
        Path srcPath = new Path(this.project, TSBuildListener.sSrcDir);
        compiler.setSrcdir(srcPath);
        compiler.setTaskName("vehicles");
        compiler.setDestdir(TSBuildListener.fClassDir);
        compiler.setFork(false);
        compiler.setIncludes("com/sun/ts/tests/common/vehicle/**/*.java");
        compiler.setExcludes("com/sun/ts/tests/common/vehicle/jbi/**/*.java");
        compiler.setDeprecation(true);
        compiler.setDebug(true);
        compiler.setClasspath(TSBuildListener.getTsClasspath(this.project));
        compiler.setFailonerror(true);
        compiler.perform();
        TSBuildListener.vehiclesBuilt = true;
    }

    private File getExistingMF(String jarName) {
        File jarFile = new File(this.distDir, jarName);
        File tmpDir = new File(this.distDir, jarName + "__tmp");
        if (tmpDir.exists()) {
            boolean quiet = true;
            TaskUtil.deleteDir(tmpDir, this.project, quiet);
        }
        Expand dfr = new Expand();
        dfr.setProject(this.project);
        dfr.init();
        dfr.setSrc(jarFile);
        dfr.setDest(tmpDir);
        dfr.perform();
        File mf = new File(tmpDir, "META-INF/MANIFEST.MF");
        return mf;
    }

    private void addFilesToArchive(String zipName) {
        Support support = null;
        File toArchive = null;
        int n = this.supports.size();
        for (int i = 0; i < n; ++i) {
            String excludes;
            support = (Support)((Object)this.supports.get(i));
            toArchive = support.getToarchive();
            if (toArchive == null || !toArchive.getName().equalsIgnoreCase(zipName)) continue;
            Jar jar = new Jar();
            jar.setProject(this.project);
            jar.init();
            jar.setUpdate(true);
            toArchive = new File(this.distDir, toArchive.getName());
            jar.setJarfile(toArchive);
            ZipFileSet zipFileSet = new ZipFileSet();
            zipFileSet.setProject(this.project);
            File dir = support.getDir(this.project);
            if (dir == null) {
                dir = this.project.getBaseDir();
            }
            zipFileSet.setDir(dir);
            String includes = support.getOriginalIncludes();
            if (includes != null && includes.length() > 0) {
                zipFileSet.setIncludes(includes);
            }
            if ((excludes = support.getOriginalExcludes()) != null && excludes.length() > 0) {
                zipFileSet.setExcludes(excludes);
            }
            String prefix = support.getPrefixinarchive();
            boolean expanded = false;
            if (zipName.indexOf("_client.jar") != -1) {
                expanded = true;
                jar.setManifest(this.getExistingMF(zipName));
            }
            if (prefix != null && prefix.length() > 0) {
                zipFileSet.setPrefix(prefix);
            }
            this.touch(toArchive);
            jar.addZipfileset(zipFileSet);
            jar.setTaskName("toarchive");
            jar.perform();
            if (!expanded) continue;
            boolean quiet = true;
            TaskUtil.deleteDir(new File(this.distDir, zipName + "__tmp"), this.project, quiet);
        }
    }

    private void touch(File file) {
        Touch touch = new Touch();
        touch.setProject(this.project);
        touch.init();
        touch.setFile(file);
        touch.setMillis(946080000000L);
        touch.perform();
    }

    private String[] getVehicles(File file) {
        VehicleVerifier vehicleVerifier = VehicleVerifier.getInstance((File)file);
        String[] vehicles = vehicleVerifier.getVehicleSet();
        if (vehicles != null) {
            return vehicles;
        }
        return TaskUtil.EMPTY_STRING_ARRAY;
    }

    private void handleSupport(Packager pkgr) {
        int n = this.supports.size();
        for (int i = 0; i < n; ++i) {
            Support spt = (Support)((Object)this.supports.get(i));
            String tovehicle = spt.getTovehicle();
            File toArchive = spt.getToarchive();
            if (toArchive != null) continue;
            if (tovehicle == null) {
                pkgr.addSupport(spt);
                continue;
            }
            if (tovehicle.equals("ejb")) {
                this.extra4Ejb = this.extra4Ejb + spt.getOriginalIncludes() + ",";
                continue;
            }
            if (tovehicle.equals("servlet")) {
                this.extra4Servlet = this.extra4Servlet + spt.getOriginalIncludes() + ",";
                continue;
            }
            if (tovehicle.equals("jsp")) {
                this.extra4Jsp = this.extra4Jsp + spt.getOriginalIncludes() + ",";
                continue;
            }
            if (!tovehicle.equals("appclient")) continue;
            this.extra4Appclient = this.extra4Appclient + spt.getOriginalIncludes() + ",";
        }
    }

    private void makeEar(String vname, String pattern) {
        if (ContainerPackage.buildLevel < 3) {
            return;
        }
        if (this.extraJars != null) {
            pattern = pattern + ", " + this.extraJars;
        }
        J2eeEar j2eeEarTask = new J2eeEar();
        j2eeEarTask.setProject(this.project);
        j2eeEarTask.init();
        j2eeEarTask.setTaskName("appear");
        j2eeEarTask.setName(this.name + vname);
        j2eeEarTask.setSrcdir(TSBuildListener.fClassDir);
        Support archives = new Support();
        archives.setDir(this.distDir);
        archives.setIncludes(pattern);
        j2eeEarTask.addSupport(archives);
        j2eeEarTask.perform();
    }

    private void initAppName() {
        this.ejbName = this.name + "_ejb_vehicle";
        this.servletName = this.name + "_servlet_vehicle";
        this.jspName = this.name + "_jsp_vehicle";
        this.appclientName = this.name + "_appclient_vehicle";
    }

    private FileSet reorgRuntimeFiles(String[] vehicles, Set customFiles) {
        FileSet result = null;
        StringBuffer sb = new StringBuffer(400);
        for (int i = 0; i < vehicles.length; ++i) {
            String v = vehicles[i];
            String mergedRuntimeFileName = null;
            if (v.equalsIgnoreCase("ejb")) {
                mergedRuntimeFileName = this.name + "_ejb_vehicle.runtime.xml";
                if (!new File(this.srcDir, mergedRuntimeFileName).exists()) continue;
                sb.append(mergedRuntimeFileName).append(',');
                customFiles.add(mergedRuntimeFileName);
                this.neededXml.remove(mergedRuntimeFileName);
                this.neededXml.remove("ejb_vehicle_ejb.runtime.xml");
                this.neededXml.remove("ejb_vehicle_client.runtime.xml");
                this.neededXml.remove(this.name + "_ejb_vehicle_ejb.runtime.xml");
                this.neededXml.remove(this.name + "_ejb_vehicle_client.runtime.xml");
                continue;
            }
            if (v.equalsIgnoreCase("servlet")) {
                mergedRuntimeFileName = this.name + "_servlet_vehicle.runtime.xml";
                if (!new File(this.srcDir, mergedRuntimeFileName).exists()) continue;
                sb.append(mergedRuntimeFileName).append(',');
                customFiles.add(mergedRuntimeFileName);
                this.neededXml.remove(mergedRuntimeFileName);
                this.neededXml.remove("servlet_vehicle_web.runtime.xml");
                this.neededXml.remove("servlet_vehicle_servlet.runtime.xml");
                this.neededXml.remove(this.name + "_servlet_vehicle_web.runtime.xml");
                this.neededXml.remove(this.name + "_servlet_vehicle_servlet.runtime.xml");
                continue;
            }
            if (v.equalsIgnoreCase("jsp")) {
                mergedRuntimeFileName = this.name + "_jsp_vehicle.runtime.xml";
                if (!new File(this.srcDir, mergedRuntimeFileName).exists()) continue;
                sb.append(mergedRuntimeFileName).append(',');
                customFiles.add(mergedRuntimeFileName);
                this.neededXml.remove("jsp_vehicle_web.runtime.xml");
                this.neededXml.remove(mergedRuntimeFileName);
                this.neededXml.remove("jsp_vehicle_jsp.runtime.xml");
                this.neededXml.remove(this.name + "_jsp_vehicle_web.runtime.xml");
                this.neededXml.remove(this.name + "_jsp_vehicle_jsp.runtime.xml");
                continue;
            }
            if (!v.equalsIgnoreCase("appclient") || !new File(this.srcDir, mergedRuntimeFileName = this.name + "_appclient_vehicle.runtime.xml").exists()) continue;
            sb.append(mergedRuntimeFileName).append(',');
            customFiles.add(mergedRuntimeFileName);
            this.neededXml.remove(mergedRuntimeFileName);
            this.neededXml.remove("appclient_vehicle_client.runtime.xml");
            this.neededXml.remove(this.name + "_appclient_vehicle_client.runtime.xml");
        }
        String s = sb.toString();
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() > 5) {
            result = new FileSet();
            result.setDir(this.srcDir);
            result.setIncludes(s);
        }
        return result;
    }

    public void copyAndReplace(String[] vehicles) {
        if (this.neededXml.size() == 0) {
            return;
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        HashSet<String> customFiles = new HashSet<String>();
        FileSet mergedRuntimeFileSet = this.reorgRuntimeFiles(vehicles, customFiles);
        if (mergedRuntimeFileSet != null) {
            fileSets.add(mergedRuntimeFileSet);
        }
        HashSet<String> mergedGenericAdded = new HashSet<String>(7);
        for (String fileName : this.neededXml) {
            File f1 = new File(this.srcDir, fileName);
            FileSet fs = new FileSet();
            if (f1.exists()) {
                fs.setDir(this.srcDir);
                fs.setIncludes(fileName);
                fileSets.add(fs);
                continue;
            }
            String s = this.name + "_" + fileName;
            File customNamedFile = new File(this.srcDir, s);
            if (customNamedFile.exists()) {
                fs.setDir(this.srcDir);
                fs.setIncludes(s);
                fileSets.add(fs);
                customFiles.add(s);
                continue;
            }
            String whichVehicle = fileName.substring(0, fileName.indexOf("_"));
            File vehicleTypeDir = new File(vehicleDir, whichVehicle);
            String mergedGeneric = whichVehicle + "_vehicle.runtime.xml";
            if (!this.separateRuntimeFiles && fileName.endsWith(".runtime.xml") && new File(vehicleTypeDir, mergedGeneric).exists()) {
                if (mergedGenericAdded.contains(mergedGeneric)) continue;
                fs.setDir(vehicleTypeDir);
                fs.setIncludes(mergedGeneric);
                fileSets.add(fs);
                mergedGenericAdded.add(mergedGeneric);
                continue;
            }
            if (new File(vehicleTypeDir, fileName).exists()) {
                fs.setDir(vehicleTypeDir);
                fs.setIncludes(fileName);
                fileSets.add(fs);
                continue;
            }
            this.log("Cannot find in vehicleDir or srcDir" + fileName);
        }
        Copy copy = new Copy();
        copy.setProject(this.project);
        copy.init();
        copy.setTaskName(this.getTaskName());
        copy.setTodir(this.distDir);
        int n = fileSets.size();
        for (int i = 0; i < n; ++i) {
            FileSet temp = (FileSet)fileSets.get(i);
            copy.addFileset(temp);
        }
        copy.setOverwrite(true);
        copy.perform();
        this.neededXml.addAll(mergedGenericAdded);
        for (String origName : this.neededXml) {
            boolean renamed;
            File orig;
            if (origName.startsWith(this.name) || !(orig = new File(this.distDir, origName)).exists()) continue;
            String sToName = this.name + "_" + origName;
            File toName = new File(this.distDir, sToName);
            if (toName.exists()) {
                if (customFiles.contains(sToName)) continue;
                if (!toName.delete()) {
                    throw new BuildException("Cannot delete old file in dist dir:" + sToName);
                }
            }
            if (renamed = orig.renameTo(toName)) continue;
            throw new BuildException("Failed to rename the file in distDir:" + origName);
        }
        try {
            this.copyS1asRuntimes(vehicles);
        }
        catch (IOException exp) {
            throw new BuildException("Failed to copy a s1as runtime file from common vehicle dir", (Throwable)exp);
        }
        this.doReplace();
    }

    private void copyS1asRuntimes(String[] vehicles) throws IOException {
        int i;
        boolean overwrite = true;
        File[] runtimes = this.srcDir.listFiles(ArchiveInfo.s1asRuntimeFileFilter);
        if (runtimes.length == 0) {
            this.log("No s1as runtime files in " + this.srcDir.getPath(), 3);
        }
        for (i = 0; i < runtimes.length; ++i) {
            File rtf = runtimes[i];
            String rtfName = rtf.getName();
            File destFile = new File(this.distDir, rtfName);
            this.fileUtils.copyFile(rtf, destFile, null, overwrite);
        }
        overwrite = false;
        for (i = 0; i < vehicles.length; ++i) {
            String veh = vehicles[i];
            File vehicleSubdir = new File(vehicleDir, veh);
            File[] s1asFiles = vehicleSubdir.listFiles(ArchiveInfo.s1asRuntimeFileFilter);
            if (s1asFiles == null) {
                throw new BuildException("vehicle subdir does not exist:" + vehicleSubdir.getPath());
            }
            if (s1asFiles.length == 0) continue;
            for (int j = 0; j < s1asFiles.length; ++j) {
                String longName = this.name + "_" + s1asFiles[j].getName();
                File destFile = new File(this.distDir, longName);
                if (destFile.exists()) continue;
                this.fileUtils.copyFile(s1asFiles[j], destFile, null, overwrite);
            }
        }
    }

    private void doReplace() {
        for (String oldVal : this.neededFilters.keySet()) {
            String newVal = (String)this.neededFilters.get(oldVal);
            Replace replacer = new Replace();
            replacer.setProject(this.project);
            replacer.init();
            replacer.setTaskName("replace");
            replacer.setDir(this.distDir);
            replacer.setDefaultexcludes(true);
            replacer.setIncludes(this.name + "*_vehicle*xml");
            replacer.setToken(oldVal);
            replacer.setValue(newVal);
            replacer.perform();
        }
    }

    public void addSupport(Support spt) {
        this.supports.add(spt);
    }

    public void setName(String testName) {
        this.name = testName;
    }

    public String getName() {
        return this.name;
    }

    public void setManifest(File manifest) {
        if (!manifest.isFile()) {
            throw new BuildException("Cannot find specified manifest file:  " + manifest);
        }
        this.manifest = manifest;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setMainclass(String mainclass) {
        this.testClientClass = mainclass;
        this.mainclass = "com.sun.ts.tests.common.vehicle.VehicleClient";
    }

    public String getMainclass() {
        return this.mainclass;
    }

    public String getExtraJars() {
        return this.extraJars;
    }

    public void setExtraJars(String extraJars) {
        this.extraJars = extraJars;
    }

    public void addcontentFileset(FileSet set) {
        this.contentFileSets.add(set);
    }

    public FileSet createContent() {
        FileSet contentFileSet = new FileSet();
        this.contentFileSets.add(contentFileSet);
        return contentFileSet;
    }

    static {
        ejbXml = "ejb_vehicle_ejb";
        ejbClientXml = "ejb_vehicle_client";
        servletXml = "servlet_vehicle_web";
        jspXml = "jsp_vehicle_web";
        appclientXml = "appclient_vehicle_client";
    }
}

