/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.invocation;

import ee.jakarta.tck.ws.rs.api.client.invocation.GenericTypeResponse;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -7647322937577043460L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void invokePlainTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder();
        Invocation invocation = builder.buildGet();
        Response r = invocation.invoke();
        this.assertContains(r, JAXRSCommonClient.Request.GET.name());
    }

    @Test
    public void invokeThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        try {
            invocation.invoke();
        }
        catch (ProcessingException ie) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown");
            return;
        }
        throw new JAXRSCommonClient.Fault("ProcessingException has NOT been thrown");
    }

    @Test
    public void invokeClassTest() throws JAXRSCommonClient.Fault {
        Entity<String> entity = this.createEntity("invokeClassTest");
        Invocation.Builder builder = this.createInvocationBuilder();
        Invocation invocation = builder.buildPost(entity);
        String r = (String)invocation.invoke(String.class);
        this.assertContains(r, JAXRSCommonClient.Request.POST.name());
        this.assertContains(r, "invokeClassTest");
    }

    @Test
    public void invokeClassThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        try {
            invocation.invoke(String.class);
        }
        catch (ProcessingException ie) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown");
            return;
        }
        throw new JAXRSCommonClient.Fault("ProcessingException has NOT been thrown");
    }

    @Test
    public void invokeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        try {
            invocation.invoke(String.class);
        }
        catch (WebApplicationException ie) {
            JAXRSClientIT.logMsg("WebApplicationException has been thrown");
            return;
        }
        throw new JAXRSCommonClient.Fault("WebApplicationException has NOT been thrown");
    }

    @Test
    public void invokeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Response r = (Response)invocation.invoke(Response.class);
        this.assertStatus(r, Response.Status.NOT_ACCEPTABLE);
        JAXRSClientIT.logMsg("Returned unexpected response with status code", r.getStatus());
    }

    @Test
    public void invokeGenericTypeTest() throws JAXRSCommonClient.Fault {
        GenericType<String> entity = new GenericType<String>(){};
        Invocation.Builder builder = this.createInvocationBuilder();
        Invocation invocation = builder.buildGet();
        String r = (String)invocation.invoke((GenericType)entity);
        this.assertContains(r, JAXRSCommonClient.Request.GET.name());
    }

    @Test
    public void invokeGenericTypeThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        try {
            invocation.invoke((GenericType)new GenericType<String>(){});
        }
        catch (ProcessingException ie) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown");
            return;
        }
        throw new JAXRSCommonClient.Fault("ProcessingException has NOT been thrown");
    }

    @Test
    public void invokeGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        try {
            invocation.invoke((GenericType)new GenericType<String>(){});
        }
        catch (WebApplicationException e) {
            JAXRSClientIT.logMsg("WebApplicationException has been thrown");
            return;
        }
        throw new JAXRSCommonClient.Fault("WebApplicationException has NOT been thrown");
    }

    @Test
    public void invokeAnnonymousGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Response response = (Response)invocation.invoke((GenericType)new GenericType<Response>(){});
        this.assertStatus(response, Response.Status.NOT_ACCEPTABLE);
        JAXRSClientIT.logMsg("Response return code is", response.getStatus(), "as expected");
    }

    @Test
    public void invokeExtendedGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Response response = (Response)invocation.invoke((GenericType)new GenericTypeResponse());
        this.assertStatus(response, Response.Status.NOT_ACCEPTABLE);
        JAXRSClientIT.logMsg("Response return code is", response.getStatus(), "as expected");
    }

    @Test
    public void submitPlainTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder();
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit();
        try {
            Response response = (Response)future.get();
            this.assertContains(response, JAXRSCommonClient.Request.GET.name());
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void submitPlainThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitClassTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder();
        Entity<String> entity = this.createEntity("submitClassTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit(String.class);
        try {
            String response = (String)future.get();
            this.assertContains(response, JAXRSCommonClient.Request.POST.name());
            this.assertContains(response, "submitClassTest");
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void submitStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(String.class);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(String.class);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(Response.class);
        this.assertStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void submitGenericTypeTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder();
        Entity<String> entity = this.createEntity("submitGenericTypeTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit((GenericType)new GenericType<String>(){});
        try {
            String response = (String)future.get();
            this.assertContains(response, JAXRSCommonClient.Request.POST.name());
            this.assertContains(response, "submitGenericTypeTest");
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void submitGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Entity<String> entity = this.createEntity("submitGenericTypeTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit((GenericType)new GenericType<String>(){});
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Entity<String> entity = this.createEntity("submitGenericTypeTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit((GenericType)new GenericType<String>(){});
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitAnnonymousGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Entity<String> entity = this.createEntity("submitGenericTypeTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit((GenericType)new GenericType<Response>(){});
        this.assertStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void submitExtendedGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Entity<String> entity = this.createEntity("submitGenericTypeTest");
        Invocation invocation = builder.buildPost(entity);
        Future future = invocation.submit((GenericType)new GenericTypeResponse());
        this.assertStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void submitInvocationCallbackTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createCallback(String.class);
        Invocation.Builder builder = this.createInvocationBuilder();
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        try {
            String response = (String)future.get();
            this.assertContains(response, JAXRSCommonClient.Request.GET.name());
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void submitInvocationCallbackThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createCallback(String.class);
        Invocation.Builder builder = this.createInvocationBuilder(null);
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitInvocationCallbackStringThrowsWebAppExceptionTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<String> callback = this.createCallback(String.class);
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void submitInvocationCallbackResponseThrowsNoWebAppExceptionTest() throws JAXRSCommonClient.Fault {
        InvocationCallback<Response> callback = this.createCallback(Response.class);
        Invocation.Builder builder = this.createInvocationBuilder(this.createBadResponseFilter());
        Invocation invocation = builder.buildGet();
        Future future = invocation.submit(callback);
        Response r = null;
        try {
            r = (Response)future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception caught", e);
        }
        this.assertStatus(r, Response.Status.NOT_ACCEPTABLE);
        JAXRSClientIT.logMsg("Found expected status code", r.getStatus());
    }

    protected ClientRequestFilter createRequestFilter() {
        ClientRequestFilter filter = new ClientRequestFilter(){

            public void filter(ClientRequestContext ctx) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append(ctx.getMethod()).append(";");
                if (ctx.hasEntity()) {
                    sb.append(ctx.getEntity()).append(";");
                }
                Response r = Response.ok((Object)sb.toString()).build();
                ctx.abortWith(r);
            }
        };
        return filter;
    }

    protected Invocation.Builder createInvocationBuilder(ClientRequestFilter filter) {
        Client client = ClientBuilder.newClient();
        if (filter != null) {
            client.register((Object)filter);
        }
        WebTarget target = client.target("http://cts.tck:888");
        Invocation.Builder builder = target.request();
        return builder;
    }

    protected Invocation.Builder createInvocationBuilder() {
        return this.createInvocationBuilder(this.createRequestFilter());
    }

    protected ClientRequestFilter createBadResponseFilter() {
        ClientRequestFilter filter = new ClientRequestFilter(){

            public void filter(ClientRequestContext arg0) throws IOException {
                Response r = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
                arg0.abortWith(r);
            }
        };
        return filter;
    }

    protected <T> InvocationCallback<T> createCallback(Class<T> clazz) {
        Object callback = null;
        if (clazz == String.class) {
            callback = new InvocationCallback<String>(){

                public void completed(String arg0) {
                }

                public void failed(Throwable throwable) {
                }
            };
        } else if (clazz == Response.class) {
            callback = new InvocationCallback<Response>(){

                public void completed(Response arg0) {
                }

                public void failed(Throwable throwable) {
                }
            };
        }
        return callback;
    }

    protected String getEntity(Response r) {
        String entity = (String)r.readEntity(String.class);
        return entity.toLowerCase();
    }

    protected <T> Entity<T> createEntity(T t) {
        return Entity.entity(t, (MediaType)MediaType.WILDCARD_TYPE);
    }

    protected void assertStatus(Response response, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((response.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Returned unexpected " + response.getStatus() + " status code"));
    }

    protected void assertContains(Response response, String what) throws JAXRSCommonClient.Fault {
        this.assertStatus(response, Response.Status.OK);
        String entity = this.getEntity(response);
        this.assertContains(entity, what);
    }

    protected void assertContains(String responseEntity, String what) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)responseEntity.toLowerCase().contains(what.toLowerCase()), (String)(responseEntity + " does not contain expected " + what));
        JAXRSClientIT.logMsg("Found expected", what);
    }

    protected void assertStatus(Future<Response> future, Response.Status status) throws JAXRSCommonClient.Fault {
        Response response;
        try {
            response = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.assertStatus(response, status);
        JAXRSClientIT.logMsg("Response cotains expected status", status);
    }

    protected void assertExceptionWithWebApplicationExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertWebApplicationExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertExceptionWithProcessingExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertProcessingExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertProcessingExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        Assertions.assertTrue((boolean)JAXRSClientIT.hasWrapped(e, ProcessingException.class), (String)("ExecutionException wrapped " + e.getCause() + " rather then ProcessingException"));
        JAXRSClientIT.logMsg("ExecutionException.getCause is ProcessingException as expected");
    }

    protected void assertWebApplicationExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        Assertions.assertTrue((boolean)JAXRSClientIT.hasWrapped(e, WebApplicationException.class), (String)("ExecutionException wrapped " + e.getCause() + " rather then WebApplicationException"));
        JAXRSClientIT.logMsg("ExecutionException.getCause is WebApplicationException as expected");
    }

    static boolean hasWrapped(Throwable parent, Class<? extends Throwable> wrapped) {
        while (parent.getCause() != null) {
            if (wrapped.isInstance(parent.getCause())) {
                return true;
            }
            parent = parent.getCause();
        }
        return false;
    }
}

