/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.forbiddenexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -2548045403083271236L;
    private static final Response.Status STATUS = Response.Status.FORBIDDEN;
    protected static final String MESSAGE = "TCK ForbiddenException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        ForbiddenException e = new ForbiddenException();
        this.assertResponse(e);
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse();
        ForbiddenException e = new ForbiddenException(response);
        this.assertResponse(e, HOST);
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ForbiddenException e = new ForbiddenException(response);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    @Test
    public void constructorThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ForbiddenException e = new ForbiddenException(t);
            this.assertResponse(e);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        Response response = this.buildResponse();
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ForbiddenException e = new ForbiddenException(response, t);
            this.assertResponse(e, HOST);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            Response response = Response.status((Response.Status)status).build();
            try {
                ForbiddenException e = new ForbiddenException(response, new Throwable());
                JAXRSClientIT.fault("ForbiddenException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been sucessfully thrown for status", status);
            }
        }
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        ForbiddenException e = new ForbiddenException(MESSAGE);
        this.assertResponse(e);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse();
        ForbiddenException e = new ForbiddenException(MESSAGE, response);
        this.assertResponse(e, HOST);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ForbiddenException e = new ForbiddenException(MESSAGE, response);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    @Test
    public void constructorStringThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ForbiddenException e = new ForbiddenException(MESSAGE, t);
            this.assertResponse(e);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        Response response = this.buildResponse();
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            ForbiddenException e = new ForbiddenException(MESSAGE, response, t);
            this.assertResponse(e, HOST);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            Response response = Response.status((Response.Status)status).build();
            try {
                ForbiddenException e = new ForbiddenException(MESSAGE, response, new Throwable());
                JAXRSClientIT.fault("ForbiddenException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been sucessfully thrown for status", status);
            }
        }
    }

    protected void assertResponse(ForbiddenException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response cobtains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertResponse(ForbiddenException e, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertMessage(ForbiddenException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertCause(e, expected.getClass(), "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected Response buildResponse() {
        Response r = Response.status((Response.Status)STATUS).header("Host", (Object)HOST).build();
        return r;
    }
}

