/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.client;

import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Provider
@Priority(value=0x7FFFFFFF)
public class JdkLoggingFilter
extends Formatter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(JdkLoggingFilter.class.getName());
    private static final String REQUEST_PREFIX = ">> ";
    private static final String RESPONSE_PREFIX = "<< ";
    private final DateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private final Logger logger;
    private boolean printEntity = true;

    public JdkLoggingFilter(boolean printEntity) {
        this(LOGGER, printEntity);
    }

    public JdkLoggingFilter(Logger logger, boolean printEntity) {
        this.logger = logger;
        this.printEntity = printEntity;
        ConsoleHandler handler = new ConsoleHandler();
        logger.setUseParentHandlers(false);
        handler.setFormatter(this);
        if (logger.getHandlers().length == 0) {
            logger.addHandler(handler);
        }
    }

    public void filter(ClientRequestContext arg0, ClientResponseContext responseContext) throws IOException {
        this.printResponseLine(responseContext.getStatus());
        this.printPrefixedHeaders(RESPONSE_PREFIX, (Map<String, List<String>>)responseContext.getHeaders());
        if (this.printEntity && responseContext.hasEntity()) {
            List<String> entity = JdkLoggingFilter.replaceEntityStream(responseContext);
            this.log(RESPONSE_PREFIX, entity);
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        this.printRequestLine(requestContext.getMethod(), requestContext.getUri());
        MultivaluedMap headers = requestContext.getHeaders();
        StringBuilder sb = new StringBuilder().append(REQUEST_PREFIX);
        for (String header : JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)headers)) {
            if (sb.length() > REQUEST_PREFIX.length()) {
                sb.append(", ");
            }
            sb.append(header);
        }
        this.log(sb);
        if (this.printEntity && requestContext.hasEntity()) {
            this.log(new StringBuilder().append(REQUEST_PREFIX).append(requestContext.getEntity().toString()));
        }
    }

    private static List<String> replaceEntityStream(ClientResponseContext ctx) throws IOException {
        List<String> entity = null;
        if (ctx.hasEntity()) {
            InputStream is = ctx.getEntityStream();
            entity = JdkLoggingFilter.readEntityFromStream(is);
            ByteArrayInputStream bais = new ByteArrayInputStream(JdkLoggingFilter.linesToBytes(entity));
            ctx.setEntityStream((InputStream)bais);
        }
        return entity;
    }

    private static byte[] linesToBytes(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = lines.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString().getBytes();
    }

    private static List<String> readEntityFromStream(InputStream is) throws IOException {
        String entity;
        LinkedList<String> lines = new LinkedList<String>();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((entity = br.readLine()) != null) {
            lines.add(entity);
        }
        return lines;
    }

    private void log(StringBuilder b) {
        if (this.logger != null) {
            this.logger.info(b.append("\n").toString());
        }
    }

    private void log(String prefix, List<String> rows) {
        if (this.logger != null && rows != null) {
            for (String row : rows) {
                this.logger.info(prefix + row + "\n");
            }
        }
    }

    private void printRequestLine(String method, URI uri) {
        StringBuilder sb = new StringBuilder();
        sb.append(REQUEST_PREFIX).append(method).append(" ").append(uri.toASCIIString());
        this.log(sb);
    }

    private void printResponseLine(int status) {
        StringBuilder sb = new StringBuilder();
        sb.append(RESPONSE_PREFIX).append(status).append(" ").append(Response.Status.fromStatusCode((int)status).name());
        this.log(sb);
    }

    private void printPrefixedHeaders(String prefix, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            StringBuilder sb = new StringBuilder();
            List<String> val = e.getValue();
            String header = e.getKey();
            if (val.size() == 1) {
                sb.append(prefix).append(header).append(": ").append(val.get(0));
            } else {
                StringBuilder sb2 = new StringBuilder();
                for (String s : val) {
                    if (sb2.length() != 0) {
                        sb2.append(',');
                    }
                    sb2.append(s);
                }
                sb.append(prefix).append(header).append(": ").append(sb2.toString());
            }
            if (sb.length() == 0) continue;
            this.log(sb);
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.df.format(new Date(record.getMillis()))).append(":  ").append("TRACE: [WIRE] - ");
        sb.append(this.formatMessage(record));
        return sb.toString();
    }
}

