/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.configuration;

import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Assertable;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.CallableProvider;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.ConfigurableObject;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Registrar;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.SingleCheckAssertable;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 7215781408688132392L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_configuration_web/resource/echo");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/configuration/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_configuration_web.war");
        archive.addClasses(new Class[]{Resource.class, TSAppConfig.class, Assertable.class, Registrar.class, CallableProvider.class, SingleCheckAssertable.class, ConfigurableObject.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void isEnabledFeatureReturningFalseTest() throws JAXRSCommonClient.Fault {
        final FeatureReturningFalse1 feature1 = new FeatureReturningFalse1();
        final FeatureReturningFalse2 feature2 = new FeatureReturningFalse2();
        final FeatureReturningFalse3 feature3 = new FeatureReturningFalse3();
        final FeatureReturningFalse4 feature4 = new FeatureReturningFalse4();
        feature1.addDisabledFeatures(feature2, feature3, feature4).setName("feature1");
        feature2.addDisabledFeatures(feature1, feature3, feature4).setName("feature2");
        feature3.addDisabledFeatures(feature1, feature2, feature4).setName("feature3");
        feature4.addDisabledFeatures(feature1, feature2, feature3).setName("feature4");
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertIsDisabled((Configurable<?>)client, feature1);
                this.assertIsDisabled((Configurable<?>)client, feature2);
                this.assertIsDisabled((Configurable<?>)client, feature3);
                this.assertIsDisabled((Configurable<?>)client, feature4);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertIsDisabled((Configurable<?>)target, feature1);
                this.assertIsDisabled((Configurable<?>)target, feature2);
                this.assertIsDisabled((Configurable<?>)target, feature3);
                this.assertIsDisabled((Configurable<?>)target, feature4);
            }

            void assertIsDisabled(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                boolean isEnabled = config.getConfiguration().isEnabled((Feature)feature);
                Assertions.assertFalse((boolean)isEnabled, (String)("Feature" + feature.getName() + "is unexpectedly enabled" + this.getLocation()));
                JAXRSCommonClient.logMsg("No feature enabled as expected", this.getLocation());
            }
        };
        Object[] instances = new Object[]{feature1, feature2, feature3, feature4};
        this.checkConfig(assertable, instances);
        JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
    }

    @Test
    public void isEnabledFeatureReturningTrueTest() throws JAXRSCommonClient.Fault {
        final FeatureReturningTrue1 feature1 = new FeatureReturningTrue1();
        final FeatureReturningTrue2 feature2 = new FeatureReturningTrue2();
        final FeatureReturningTrue3 feature3 = new FeatureReturningTrue3();
        final FeatureReturningTrue4 feature4 = new FeatureReturningTrue4();
        feature1.addDisabledFeatures(feature2, feature3, feature4).setName("feature1");
        feature2.addDisabledFeatures(feature3, feature4).addEnabledFeatures(feature1).setName("feature2");
        feature3.addDisabledFeatures(feature4).addEnabledFeatures(feature1, feature2).setName("feature3");
        feature4.addEnabledFeatures(feature1, feature2, feature3).setName("feature4");
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertIsRegistered((Configurable<?>)client, feature1);
                this.assertIsNotRegistered((Configurable<?>)client, feature2);
                this.assertIsNotRegistered((Configurable<?>)client, feature3);
                this.assertIsNotRegistered((Configurable<?>)client, feature4);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertIsRegistered((Configurable<?>)target, feature1);
                this.assertIsRegistered((Configurable<?>)target, feature2);
                this.assertIsNotRegistered((Configurable<?>)target, feature3);
                this.assertIsNotRegistered((Configurable<?>)target, feature4);
            }

            void assertIsRegistered(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                Configuration configuration = config.getConfiguration();
                Assertions.assertTrue((boolean)configuration.isRegistered((Object)feature), (String)("Feature" + feature.getName() + "is NOT registered" + this.getLocation()));
                JAXRSCommonClient.logMsg("Feature", feature.getName(), "registered as expected", this.getLocation());
            }

            void assertIsNotRegistered(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                Configuration configuration = config.getConfiguration();
                Assertions.assertFalse((boolean)configuration.isRegistered((Object)feature), (String)("Feature" + feature.getName() + "is unexpectedly registered" + this.getLocation()));
                JAXRSCommonClient.logMsg("Feature", feature.getName(), "NOT registered as expected", this.getLocation());
            }
        };
        Object[] instances = new Object[]{feature1, feature2, feature3, feature4};
        this.checkConfig(assertable, instances);
        JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
    }

    @Test
    public void isEnabledClassReturningFalseTest() throws JAXRSCommonClient.Fault {
        final FeatureReturningFalse1 feature1 = new FeatureReturningFalse1();
        final FeatureReturningFalse2 feature2 = new FeatureReturningFalse2();
        final FeatureReturningFalse3 feature3 = new FeatureReturningFalse3();
        final FeatureReturningFalse4 feature4 = new FeatureReturningFalse4();
        feature1.addDisabledClasses(FeatureReturningFalse2.class, FeatureReturningFalse3.class, FeatureReturningFalse4.class).setName("feature1");
        feature2.addDisabledClasses(FeatureReturningFalse1.class, FeatureReturningFalse3.class, FeatureReturningFalse4.class).setName("feature2");
        feature3.addDisabledClasses(FeatureReturningFalse1.class, FeatureReturningFalse2.class, FeatureReturningFalse4.class).setName("feature3");
        feature4.addDisabledClasses(FeatureReturningFalse1.class, FeatureReturningFalse2.class, FeatureReturningFalse3.class).setName("feature4");
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertIsDisabled((Configurable<?>)client, feature1);
                this.assertIsDisabled((Configurable<?>)client, feature2);
                this.assertIsDisabled((Configurable<?>)client, feature3);
                this.assertIsDisabled((Configurable<?>)client, feature4);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertIsDisabled((Configurable<?>)target, feature1);
                this.assertIsDisabled((Configurable<?>)target, feature2);
                this.assertIsDisabled((Configurable<?>)target, feature3);
                this.assertIsDisabled((Configurable<?>)target, feature4);
            }

            void assertIsDisabled(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                boolean isEnabled = config.getConfiguration().isEnabled((Feature)feature);
                Assertions.assertFalse((boolean)isEnabled, (String)("Feature" + feature.getName() + "is unexpectedly enabled" + this.getLocation()));
                JAXRSCommonClient.logMsg("No feature enabled as expected", this.getLocation());
            }
        };
        Object[] instances = new Object[]{feature1, feature2, feature3, feature4};
        this.checkConfig(assertable, instances);
        JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
    }

    @Test
    public void isEnabledFeatureClassReturningTrueTest() throws JAXRSCommonClient.Fault {
        final FeatureReturningTrue1 feature1 = new FeatureReturningTrue1();
        final FeatureReturningTrue2 feature2 = new FeatureReturningTrue2();
        final FeatureReturningTrue3 feature3 = new FeatureReturningTrue3();
        final FeatureReturningTrue4 feature4 = new FeatureReturningTrue4();
        feature1.addDisabledClasses(FeatureReturningTrue2.class, FeatureReturningTrue3.class, FeatureReturningTrue4.class).setName("feature1");
        feature2.addDisabledClasses(FeatureReturningTrue3.class, FeatureReturningTrue4.class).addEnabledClasses(FeatureReturningTrue1.class).setName("feature2");
        feature3.addDisabledClasses(FeatureReturningTrue4.class).addEnabledClasses(FeatureReturningTrue1.class, FeatureReturningTrue2.class).setName("feature3");
        feature4.addEnabledClasses(FeatureReturningTrue1.class, FeatureReturningTrue2.class, FeatureReturningTrue3.class).setName("feature4");
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertIsRegistered((Configurable<?>)client, feature1);
                this.assertIsNotRegistered((Configurable<?>)client, feature2);
                this.assertIsNotRegistered((Configurable<?>)client, feature3);
                this.assertIsNotRegistered((Configurable<?>)client, feature4);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertIsRegistered((Configurable<?>)target, feature1);
                this.assertIsRegistered((Configurable<?>)target, feature2);
                this.assertIsNotRegistered((Configurable<?>)target, feature3);
                this.assertIsNotRegistered((Configurable<?>)target, feature4);
            }

            void assertIsRegistered(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                Configuration configuration = config.getConfiguration();
                Assertions.assertTrue((boolean)configuration.isRegistered((Object)feature), (String)("Feature" + feature.getName() + "is NOT registered" + this.getLocation()));
                JAXRSCommonClient.logMsg("Feature", feature.getName(), "registered as expected", this.getLocation());
            }

            void assertIsNotRegistered(Configurable<?> config, CheckingFeature feature) throws JAXRSCommonClient.Fault {
                Configuration configuration = config.getConfiguration();
                Assertions.assertFalse((boolean)configuration.isRegistered((Object)feature), (String)("Feature" + feature.getName() + "is unexpectedly registered" + this.getLocation()));
                JAXRSCommonClient.logMsg("Feature", feature.getName(), "NOT registered as expected", this.getLocation());
            }
        };
        Object[] instances = new Object[]{feature1, feature2, feature3, feature4};
        this.checkConfig(assertable, instances);
        JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
    }

    protected void checkConfig(Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        this.checkConfig(new Registrar(), assertable, registerables);
    }

    protected void checkConfig(Registrar registrar, Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"echo", (MediaType)MediaType.WILDCARD_TYPE);
        Client client = ClientBuilder.newClient();
        JAXRSClientIT.logMsg("Registering on Client");
        this.register(registrar, (Configurable<?>)client, registerables[0]);
        WebTarget target = client.target(this.getAbsoluteUrl());
        JAXRSClientIT.logMsg("Registering on WebTarget");
        this.register(registrar, (Configurable<?>)target, registerables[1]);
        Invocation.Builder builder = target.request();
        Invocation invocation = builder.buildPost(entity);
        String response = (String)invocation.invoke(String.class);
        JAXRSClientIT.assertEquals((String)entity.getEntity(), response, "Unexpected response received", response);
        assertable.check1OnClient(client);
        assertable.incrementLocation();
        assertable.check2OnTarget(target);
    }

    protected void register(Registrar registrar, Configurable<?> config, Object registerable) {
        registrar.register(config, registerable);
    }

    private class FeatureReturningTrue4
    extends FeatureReturningTrue {
        private FeatureReturningTrue4() {
        }
    }

    private class FeatureReturningTrue3
    extends FeatureReturningTrue {
        private FeatureReturningTrue3() {
        }
    }

    private class FeatureReturningTrue2
    extends FeatureReturningTrue {
        private FeatureReturningTrue2() {
        }
    }

    private class FeatureReturningTrue1
    extends FeatureReturningTrue {
        private FeatureReturningTrue1() {
        }
    }

    private class FeatureReturningFalse4
    extends FeatureReturningFalse {
        private FeatureReturningFalse4() {
        }
    }

    private class FeatureReturningFalse3
    extends FeatureReturningFalse {
        private FeatureReturningFalse3() {
        }
    }

    private class FeatureReturningFalse2
    extends FeatureReturningFalse {
        private FeatureReturningFalse2() {
        }
    }

    private class FeatureReturningFalse1
    extends FeatureReturningFalse {
        private FeatureReturningFalse1() {
        }
    }

    private class FeatureReturningTrue
    extends CheckingFeature {
        private FeatureReturningTrue() {
        }

        @Override
        public boolean configure(FeatureContext context) {
            return super.configure(context);
        }
    }

    private class FeatureReturningFalse
    extends CheckingFeature {
        private FeatureReturningFalse() {
        }

        @Override
        public boolean configure(FeatureContext context) {
            super.configure(context);
            return false;
        }
    }

    class CheckingFeature
    extends NamedFeature {
        List<NamedFeature> enabledFeatures;
        List<NamedFeature> disabledFeatures;
        List<Class<? extends NamedFeature>> enabledFeatureClasses;
        List<Class<? extends NamedFeature>> disabledFeatureClasses;

        CheckingFeature() {
            this.enabledFeatures = new LinkedList<NamedFeature>();
            this.disabledFeatures = new LinkedList<NamedFeature>();
            this.enabledFeatureClasses = new LinkedList<Class<? extends NamedFeature>>();
            this.disabledFeatureClasses = new LinkedList<Class<? extends NamedFeature>>();
        }

        public boolean configure(FeatureContext context) {
            for (NamedFeature namedFeature : this.enabledFeatures) {
                if (!context.getConfiguration().isEnabled((Feature)namedFeature)) {
                    throw new RuntimeException("Feature " + namedFeature.getName() + " has NOT been enabled");
                }
                JAXRSCommonClient.logMsg("Feature", namedFeature.getName(), "has been enabled as expected");
            }
            for (NamedFeature namedFeature : this.disabledFeatures) {
                if (context.getConfiguration().isEnabled((Feature)namedFeature)) {
                    throw new RuntimeException("Feature " + namedFeature.getName() + " has been unexpectedly enabled");
                }
                JAXRSCommonClient.logMsg("Feature", namedFeature.getName(), "has NOT been enabled as expected");
            }
            for (Class clazz : this.enabledFeatureClasses) {
                if (!context.getConfiguration().isEnabled(clazz)) {
                    throw new RuntimeException("Feature " + clazz.getName() + " has NOT been enabled");
                }
                JAXRSCommonClient.logMsg("Feature", clazz.getName(), "has been enabled as expected");
            }
            for (Class clazz : this.disabledFeatureClasses) {
                if (context.getConfiguration().isEnabled(clazz)) {
                    throw new RuntimeException("Feature " + clazz.getName() + " has been unexpectedly enabled");
                }
                JAXRSCommonClient.logMsg("Feature", clazz.getName(), "has NOT been enabled as expected");
            }
            return true;
        }

        public CheckingFeature addEnabledFeatures(NamedFeature ... features) {
            if (features != null) {
                for (NamedFeature feature : features) {
                    this.enabledFeatures.add(feature);
                }
            }
            return this;
        }

        public CheckingFeature addDisabledFeatures(NamedFeature ... features) {
            if (features != null) {
                for (NamedFeature feature : features) {
                    this.disabledFeatures.add(feature);
                }
            }
            return this;
        }

        public CheckingFeature addEnabledClasses(Class<? extends NamedFeature> ... features) {
            if (features != null) {
                for (Class<? extends NamedFeature> feature : features) {
                    this.enabledFeatureClasses.add(feature);
                }
            }
            return this;
        }

        public CheckingFeature addDisabledClasses(Class<? extends NamedFeature> ... features) {
            if (features != null) {
                for (Class<? extends NamedFeature> feature : features) {
                    this.disabledFeatureClasses.add(feature);
                }
            }
            return this;
        }
    }

    private abstract class NamedFeature
    implements Feature {
        String name;

        private NamedFeature() {
        }

        public String getName() {
            return this.name;
        }

        public NamedFeature setName(String name) {
            this.name = name;
            return this;
        }
    }
}

