/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
public class EntityMessageWriter
extends AbstractMessageBodyRW
implements MessageBodyWriter<ReadableWritableEntity> {
    public long getSize(ReadableWritableEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.toXmlString().length();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String path = EntityMessageWriter.getPathValue(annotations);
        if (path == null) {
            return false;
        }
        path = path.toLowerCase();
        boolean writable = path.contains("body");
        writable |= path.contains("head");
        writable |= path.contains("ioexception");
        writable &= MediaType.TEXT_XML_TYPE.isCompatible(mediaType);
        return writable &= ReadableWritableEntity.class.isAssignableFrom(type);
    }

    public void writeTo(ReadableWritableEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String path = EntityMessageWriter.getPathValue(annotations).toLowerCase();
        if (path.contains("body")) {
            entityStream.write(t.toXmlString().getBytes());
        } else if (path.contains("head")) {
            httpHeaders.add((Object)"READABLEWRITEABLE", (Object)t.toXmlString());
        } else if (path.contains("ioexception")) {
            throw new IOException("CTS test IOException");
        }
    }
}

