/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.lastvalue;

import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;

@Provider
public class ArrayListEntityProvider
implements MessageBodyReader<ArrayList<String>>,
MessageBodyWriter<ArrayList<String>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == ArrayList.class;
    }

    public long getSize(ArrayList<String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        int annlen = annotations.length > 0 ? annotations[0].annotationType().getName().length() : 0;
        return t.iterator().next().length() + annlen + mediaType.toString().length();
    }

    public void writeTo(ArrayList<String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String ann = "";
        if (annotations.length > 0) {
            ann = annotations[0].annotationType().getName();
        }
        entityStream.write((t.iterator().next() + ann + mediaType.toString()).getBytes());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == ArrayList.class;
    }

    public ArrayList<String> readFrom(Class<ArrayList<String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String text = JaxrsUtil.readFromStream(entityStream);
        entityStream.close();
        String ann = "";
        if (annotations.length > 0) {
            ann = annotations[0].annotationType().getName();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(text + ann + mediaType.toString());
        return list;
    }
}

