/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standard;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.standard.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.standard.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    String[] methodsAll = new String[]{"bytearray", "string", "inputstream", "file", "datasource", "streamingoutput"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_standard_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        String ct = JAXRSClientIT.buildContentType(md);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        if (!MediaType.WILDCARD_TYPE.equals((Object)md)) {
            this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, ct);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(md));
        this.invoke();
    }

    private void setEntityAndPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, resourceMethod);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, resourceMethod);
        this.setPropertyAndInvoke(resourceMethod, md);
    }

    private void setPropertyAndInvoke(String resourceMethod) throws JAXRSCommonClient.Fault {
        this.setEntityAndPropertyAndInvoke(resourceMethod, MediaType.APPLICATION_SVG_XML_TYPE);
    }

    private void setPropertyAndInvokeXml(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "<tag>" + resourceMethod + "</tag>");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, resourceMethod);
        this.setPropertyAndInvoke(resourceMethod, md);
    }

    private void setPropertyAndInvokeXml(String method) throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvokeXml(method, MediaType.TEXT_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_ATOM_XML_TYPE);
        this.setPropertyAndInvokeXml(method, MediaType.APPLICATION_SVG_XML_TYPE);
        this.setPropertyAndInvokeXml(method, new MediaType("application", "*+xml"));
    }

    protected <T> T[] getMediaTypes(Class<T> clazz) throws JAXRSCommonClient.Fault {
        MediaType type = MediaType.WILDCARD_TYPE;
        LinkedList<Object> list = new LinkedList<Object>();
        for (Field field : MediaType.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.getType().equals(clazz)) continue;
            try {
                Object value = field.get(type);
                if (!value.toString().contains("/")) continue;
                list.add(value);
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        return list.toArray(array);
    }

    @Override
    protected String getAbsoluteUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this._hostname).append(":").append(this._port).append(this.getContextRoot());
        return sb.toString();
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/standard/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_standard_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, StringStreamingOutput.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void byteArrayProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[0], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[0] + "svg");
    }

    @Test
    public void stringProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[1], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[1] + "svg");
    }

    @Test
    public void inputStreamProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[2], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[2] + "svg");
    }

    @Test
    public void readerProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke("reader", media);
        }
        this.setPropertyAndInvoke("readersvg");
    }

    @Test
    public void fileProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[3], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[3] + "svg");
    }

    @Test
    public void dataSourceProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[4], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[4] + "svg");
    }

    @Test
    public void sourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvokeXml("source");
    }

    @Test
    public void streamingOutputProviderTest() throws JAXRSCommonClient.Fault {
        for (MediaType media : this.getMediaTypes(MediaType.class)) {
            this.setEntityAndPropertyAndInvoke(this.methodsAll[5], media);
        }
        this.setPropertyAndInvoke(this.methodsAll[5] + "svg");
    }
}

