/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletrequest30;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import servlet.tck.common.servlets.GenericTCKServlet;

public class AsyncTestServlet
extends GenericTCKServlet {
    public void getDispatcherTypeTestAsync(ServletRequest request, ServletResponse response) {
        String path = "/async/AsyncTests?testname=getDispatcherTypeTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
    }

    public void asyncStartedTest1(ServletRequest request, ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
        ac.complete();
    }

    public void asyncStartedTest2(ServletRequest request, ServletResponse response) throws IOException {
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
    }

    public void asyncStartedTest3(ServletRequest request, ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        ac.complete();
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
    }

    public void asyncStartedTest4(ServletRequest request, ServletResponse response) {
        String path = "/async/AsyncTests?testname=isAsyncStartedTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
    }

    public void isAsyncSupportedTest(ServletRequest request, ServletResponse response) throws IOException {
        response.getWriter().println("isAsyncSupported=" + request.isAsyncSupported());
    }

    public void startAsyncTest(ServletRequest request, ServletResponse response) throws IOException {
        String path = "/async/AsyncTests?testname=getDispatcherTypeTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
        try {
            request.startAsync();
            response.getWriter().println("Expected IllegalStateException not thrown in AsyncTestServlet#startAsyncTest. Test FAILED.");
        }
        catch (IllegalStateException ise) {
            response.getWriter().println("Expected IllegalStateException thrown in AsyncTestServlet#startAsyncTest. Test PASSED.");
        }
    }

    public void getAsyncContextTest(ServletRequest request, ServletResponse response) throws IOException {
        AsyncContext ac1;
        AsyncContext ac = request.startAsync();
        if (ac != (ac1 = request.getAsyncContext())) {
            response.getWriter().println("getAsyncContext returned is different. Test FAILED.");
        } else {
            response.getWriter().println("getAsyncContext returned is correct. Test PASSED.");
        }
        ac.complete();
    }
}

