/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.ecore4reg.model.ecore4reg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Comparitor implements Enumerator
{
    LESS_THAN(0, "less_than", "less_than"),
    EQUALS(1, "equals", "equals"),
    GREATER_THAN(2, "greater_than", "greater_than"),
    NOT_EQUALS(3, "not_equals", "not_equals");

    public static final int LESS_THAN_VALUE = 0;
    public static final int EQUALS_VALUE = 1;
    public static final int GREATER_THAN_VALUE = 2;
    public static final int NOT_EQUALS_VALUE = 3;
    private static final Comparitor[] VALUES_ARRAY;
    public static final List<Comparitor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Comparitor[]{LESS_THAN, EQUALS, GREATER_THAN, NOT_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Comparitor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparitor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparitor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparitor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparitor get(int value) {
        switch (value) {
            case 0: {
                return LESS_THAN;
            }
            case 1: {
                return EQUALS;
            }
            case 2: {
                return GREATER_THAN;
            }
            case 3: {
                return NOT_EQUALS;
            }
        }
        return null;
    }

    private Comparitor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

