/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.win32;

import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.jni.win32.Win32;
import org.eclipse.fx.drift.internal.jni.win32.WindowsError;

public class NVDXInterop {
    private static final DriftLogger LOGGER = DriftFX.createLogger(NVDXInterop.class);
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;

    public static Win32.HANDLE wglDXOpenDeviceNV(Win32.IDirect3DDevice9Ex dxDevice) throws WindowsError {
        long result = NVDXInterop.nWglDXOpenDeviceNV(dxDevice.address);
        if (result == 0L) {
            WindowsError.checkLastError();
        }
        return new Win32.HANDLE(result);
    }

    private static native long nWglDXOpenDeviceNV(long var0);

    public static boolean wglDXCloseDeviceNV(Win32.HANDLE hDevice) throws WindowsError {
        boolean result = NVDXInterop.nWglDXCloseDeviceNV(hDevice.address);
        if (!result) {
            WindowsError.checkLastError();
        }
        return result;
    }

    private static native boolean nWglDXCloseDeviceNV(long var0);

    public static boolean isAvailable() {
        return NVDXInterop.nIsAvailable();
    }

    private static native boolean nIsAvailable();

    public static boolean wglDXSetResourceShareHandleNV(Win32.IDirect3DResource9 dxResource, Win32.HANDLE shareHandle) throws WindowsError {
        boolean result = NVDXInterop.nWglDXSetResourceShareHandleNV(dxResource.address, shareHandle.address);
        LOGGER.debug(() -> result + " = wglDXSetResourceShareHandleNV(" + Long.toHexString(dxResource.address) + ", " + Long.toHexString(shareHandle.address) + ")");
        if (!result) {
            WindowsError.checkLastError();
        }
        return result;
    }

    private static native boolean nWglDXSetResourceShareHandleNV(long var0, long var2);

    public static Win32.HANDLE wglDXRegisterObjectNV(Win32.HANDLE hDevice, Win32.IDirect3DResource9 dxResource, int name, int type, int access) throws WindowsError {
        long result = NVDXInterop.nWglDXRegisterObjectNV(hDevice.address, dxResource.address, name, type, access);
        LOGGER.debug(() -> Long.toHexString(result) + " = wglDXRegisterObjectNV(" + Long.toHexString(hDevice.address) + ", " + Long.toHexString(dxResource.address) + ", " + name + ", " + type + ", " + access + ")");
        if (result == 0L) {
            WindowsError.checkLastError();
        }
        return new Win32.HANDLE(result);
    }

    private static native long nWglDXRegisterObjectNV(long var0, long var2, int var4, int var5, int var6);

    public static boolean wglDXUnregisterObjectNV(Win32.HANDLE hDevice, Win32.HANDLE hObject) throws WindowsError {
        boolean result = NVDXInterop.nWglDXUnregisterObjectNV(hDevice.address, hObject.address);
        LOGGER.debug(() -> "calling wglDXUnregisterObjectNV(" + Long.toHexString(hDevice.address) + ", " + Long.toHexString(hObject.address) + ")");
        if (!result) {
            WindowsError.checkLastError();
        }
        return result;
    }

    private static native boolean nWglDXUnregisterObjectNV(long var0, long var2);

    public static boolean wglDXLockObjectsNV(Win32.HANDLE hDevice, Win32.HANDLE hObject) throws WindowsError {
        boolean result = NVDXInterop.nWglDXLockObjectsNV(hDevice.address, hObject.address);
        if (!result) {
            WindowsError.checkLastError();
        }
        return result;
    }

    private static native boolean nWglDXLockObjectsNV(long var0, long var2);

    public static boolean wglDXUnlockObjectsNV(Win32.HANDLE hDevice, Win32.HANDLE hObject) throws WindowsError {
        boolean result = NVDXInterop.nWglDXUnlockObjectsNV(hDevice.address, hObject.address);
        if (!result) {
            WindowsError.checkLastError();
        }
        return result;
    }

    private static native boolean nWglDXUnlockObjectsNV(long var0, long var2);

    static {
        GL.require();
    }
}

