/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.GPUSyncUtil;
import org.eclipse.fx.drift.internal.Log;

public class QuantumRendererHelper {
    static boolean initialized = false;
    static Executor executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("QuantumRenderer-DriftFX-Helper");
            t.setDaemon(true);
            return t;
        }
    });
    public static long context;

    public static void initialize(long es2ContextHandle) {
        if (!initialized) {
            context = QuantumRendererHelper.syncExecute(() -> {
                Log.info("QuantumRendererHelper: creating shared context for " + es2ContextHandle);
                long es2Context = GL.wrapContext(es2ContextHandle);
                long context = GL.createSharedCompatContext(es2Context);
                boolean result = GL.makeContextCurrent(context);
                Log.info("=> " + result);
                return context;
            });
            initialized = true;
        }
    }

    public static <T> T syncExecute(Supplier<T> r) {
        return QuantumRendererHelper.internalSyncExecute(r);
    }

    public static <T> WithFence<T> syncExecuteWithFence(Supplier<T> r) {
        T result = QuantumRendererHelper.syncExecute(r);
        GPUSyncUtil.GPUSync fence = GPUSyncUtil.createFence();
        return new WithFence<T>(result, fence);
    }

    public static void syncExecute(Runnable r) {
        QuantumRendererHelper.internalSyncExecute(r);
    }

    public static GPUSyncUtil.GPUSync syncExecuteWithFence(Runnable r) {
        QuantumRendererHelper.syncExecute(r);
        return GPUSyncUtil.createFence();
    }

    static void internalSyncExecute(Runnable r) {
        ReentrantLock lock = new ReentrantLock();
        Condition done = lock.newCondition();
        lock.lock();
        executor.execute(() -> {
            lock.lock();
            r.run();
            done.signal();
            lock.unlock();
        });
        try {
            done.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static <T> T internalSyncExecute(Supplier<T> r) {
        ReentrantLock lock = new ReentrantLock();
        AtomicReference result = new AtomicReference();
        Condition done = lock.newCondition();
        lock.lock();
        executor.execute(() -> {
            lock.lock();
            result.set(r.get());
            done.signal();
            lock.unlock();
        });
        try {
            done.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return (T)result.get();
    }

    public static class WithFence<T> {
        private GPUSyncUtil.GPUSync sync;
        private T result;

        public WithFence(T result, GPUSyncUtil.GPUSync sync) {
            this.sync = sync;
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }

        public GPUSyncUtil.GPUSync getFence() {
            return this.sync;
        }
    }
}

