/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.time.Duration;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.GraphicsPipelineUtil;

public class GPUSyncUtil {
    private static final DriftLogger LOGGER = DriftFX.createLogger(GPUSyncUtil.class);

    public static GPUSync createFence() {
        if (GraphicsPipelineUtil.isES2()) {
            return GLSync.CreateFence();
        }
        return new D3DSync();
    }

    public static class GLSync
    implements GPUSync {
        private long sync = GL.glCreateFence();

        private GLSync() {
        }

        private void checkSync() {
            if (this.sync == 0L) {
                throw new RuntimeException("sync object was already deleted!");
            }
        }

        public static GLSync CreateFence() {
            return new GLSync();
        }

        @Override
        public WaitSyncResult ClientWaitSync(Duration timeout) {
            this.checkSync();
            int r = GL.glClientWaitSync(this.sync, timeout.toNanos());
            switch (r) {
                case 37146: {
                    return WaitSyncResult.AREADY_SIGNALED;
                }
                case 37147: {
                    return WaitSyncResult.TIMEOUT_EXPIRED;
                }
                case 37148: {
                    return WaitSyncResult.CONDITION_SATISFIED;
                }
                case 37149: {
                    return WaitSyncResult.WAIT_FAILED;
                }
            }
            LOGGER.error(() -> "glClientWaitSync: Unexpected result!!! " + r);
            return WaitSyncResult.WAIT_FAILED;
        }

        @Override
        public void WaitSync() {
            this.checkSync();
            GL.glWaitSync(this.sync);
        }

        @Override
        public void Delete() {
            this.checkSync();
            GL.glDeleteSync(this.sync);
            this.sync = 0L;
        }
    }

    public static class D3DSync
    implements GPUSync {
        @Override
        public WaitSyncResult ClientWaitSync(Duration timeout) {
            return WaitSyncResult.AREADY_SIGNALED;
        }

        @Override
        public void WaitSync() {
        }

        @Override
        public void Delete() {
        }
    }

    public static interface GPUSync {
        public WaitSyncResult ClientWaitSync(Duration var1);

        public void WaitSync();

        public void Delete();
    }

    public static enum WaitSyncResult {
        AREADY_SIGNALED,
        TIMEOUT_EXPIRED,
        CONDITION_SATISFIED,
        WAIT_FAILED;

    }
}

