/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.processing.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.BreakpointPackage;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;
import org.eclipse.emf.mwe.internal.core.debug.processing.ProcessHandler;
import org.eclipse.emf.mwe.internal.core.debug.processing.RuntimeHandler;

public class BreakpointRuntimeHandler
implements RuntimeHandler,
ProcessHandler,
Runnable {
    public static final int SET = 1;
    public static final int REMOVE = 2;
    protected Connection connection;
    protected DebugMonitor monitor;
    private final List<Object> breakpoints = new ArrayList<Object>();
    private final List<SyntaxElement> breakpointTOs = new ArrayList<SyntaxElement>();
    private final List<SyntaxElement> toBeRemovedTOs = new ArrayList<SyntaxElement>();

    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        if (monitor != null) {
            monitor.addProcessHandler(this);
        }
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            while (true) {
                this.listenAndDispatchCommand();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void listenAndDispatchCommand() throws IOException {
        this.handle((BreakpointPackage)this.connection.listenForPackage(BreakpointPackage.class));
    }

    private void handle(BreakpointPackage packet) {
        switch (packet.type) {
            case 1: {
                this.doSet(packet.se, null, 0);
                break;
            }
            case 2: {
                this.doRemove(packet.se, null, 0);
                break;
            }
        }
    }

    private void doSet(SyntaxElement se, Object actual, int flag) {
        ElementAdapter adapter = this.monitor.getAdapter(se);
        if (adapter == null) {
            return;
        }
        Object element = adapter.findElement(se, actual, flag);
        if (element == null) {
            this.breakpointTOs.add(se);
            for (SyntaxElement cand : this.toBeRemovedTOs) {
                if (!se.equalsBP(cand)) continue;
                this.toBeRemovedTOs.remove(cand);
                break;
            }
        } else {
            this.breakpoints.add(element);
        }
    }

    private void doRemove(SyntaxElement se, Object actual, int flag) {
        ElementAdapter adapter = this.monitor.getAdapter(se);
        if (adapter == null) {
            return;
        }
        Object element = adapter.findElement(se, actual, flag);
        if (element == null) {
            this.toBeRemovedTOs.add(se);
            for (SyntaxElement cand : this.breakpointTOs) {
                if (!se.equalsBP(cand)) continue;
                this.breakpointTOs.remove(cand);
                break;
            }
        } else {
            this.breakpoints.remove(element);
        }
    }

    public boolean isLastCall() {
        return false;
    }

    public boolean shallSuspend(boolean lastState, Object element, int flag) {
        ArrayList<SyntaxElement> temp;
        if (!this.toBeRemovedTOs.isEmpty()) {
            temp = new ArrayList<SyntaxElement>();
            temp.addAll(this.toBeRemovedTOs);
            this.toBeRemovedTOs.clear();
            for (SyntaxElement se : temp) {
                this.doRemove(se, element, flag);
            }
        }
        if (!this.breakpointTOs.isEmpty()) {
            temp = new ArrayList();
            temp.addAll(this.breakpointTOs);
            this.breakpointTOs.clear();
            for (SyntaxElement se : temp) {
                this.doSet(se, element, flag);
            }
        }
        return lastState || this.breakpoints.contains(element);
    }

    public boolean shallHandle(boolean lastState, Object element, int flag) {
        return lastState;
    }

    public boolean shallInterrupt(boolean lastState) {
        return lastState;
    }
}

