/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.asciidoc.fx;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceFileChange;
import org.eclipse.fx.code.editor.SourceFileInput;
import org.eclipse.fx.code.editor.asciidoc.HTMLConverter;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.event.Event;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.preferences.Preference;

public class AsciiDoctorPreviewer {
    private final Input<String> input;
    private final HTMLConverter converter;
    private final ThreadSynchronize threadSynchronize;
    private final SimpleStringProperty content;
    private WebView view;
    private Subscription updateSubscription;
    private Subscription fileChangeSubscription;
    private EventBus eventBus;

    @Inject
    public AsciiDoctorPreviewer(Input<String> input, @Optional HTMLConverter converter, ThreadSynchronize threadSynchronize, EventBus eventBus) {
        this.input = input;
        this.converter = converter;
        this.threadSynchronize = threadSynchronize;
        this.content = new SimpleStringProperty((String)this.input.getData());
        this.eventBus = eventBus;
        eventBus.subscribe(Constants.TOPIC_SOURCE_FILE_INPUT_SAVED, this::handleFileSaved);
        this.updateSubscription = threadSynchronize.delayedChangeExecution(400L, (ObservableValue)this.content, this::refreshPreview);
    }

    @Inject
    public void setUpdateOnDelay(@Preference(key="refresh-onchange", defaultValue="true") boolean value) {
        System.err.println("VALUE: " + value);
        if (value) {
            if (this.fileChangeSubscription == null) {
                this.fileChangeSubscription = this.eventBus.subscribe(Constants.TOPIC_SOURCE_FILE_INPUT_MODIFIED, this::handleFileChange);
            }
        } else if (this.fileChangeSubscription != null) {
            this.fileChangeSubscription.dispose();
            this.fileChangeSubscription = null;
        }
    }

    private void handleFileChange(Event<SourceFileChange> event) {
        if (((SourceFileChange)event.getData()).input == this.input) {
            this.content.set((String)((SourceFileChange)event.getData()).input.getData());
        }
    }

    private void handleFileSaved(Event<SourceFileInput> event) {
        if (event.getData() == this.input) {
            this.content.set((String)((SourceFileInput)event.getData()).getData());
        }
    }

    private void refreshPreview(String data) {
        if (this.converter != null) {
            CompletableFuture convert = this.converter.convert("", data);
            Consumer consumer = this.threadSynchronize.wrap(arg_0 -> ((WebEngine)this.view.getEngine()).loadContent(arg_0));
            convert.thenAccept(consumer);
        }
    }

    @PostConstruct
    void init(BorderPane parent) {
        this.view = new WebView();
        this.refreshPreview((String)this.input.getData());
        parent.setCenter((Node)this.view);
    }

    @PreDestroy
    void dispose() {
        this.updateSubscription.dispose();
    }
}

