/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.Equals;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;

public final class GsonEqualsImpl
implements GsonBase,
Equals,
Check {
    private final int value;

    public GsonEqualsImpl(JsonObject jsonObject) {
        this.value = jsonObject.has("value") ? jsonObject.get("value").getAsInt() : 0;
    }

    public GsonEqualsImpl(int value) {
        this.value = value;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "Equals");
        o.addProperty("value", (Number)this.getValue());
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "value : " + this.value + " }";
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static class Builder
    implements Equals.Builder {
        private final EditorGModel instance;
        private int value;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder value(int value) {
            this.value = value;
            return this;
        }

        @Override
        public Equals build() {
            return new GsonEqualsImpl(this.value);
        }
    }
}

