/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.LanguageDef;
import org.eclipse.fx.code.editor.configuration.Partition;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;
import org.eclipse.fx.code.editor.configuration.gson.GsonPartitionImpl;

public final class GsonLanguageDefImpl
implements GsonBase,
LanguageDef {
    private final String fileSuffix;
    private final List<Partition> partitionList;

    public GsonLanguageDefImpl(JsonObject jsonObject) {
        this.fileSuffix = jsonObject.has("fileSuffix") ? jsonObject.get("fileSuffix").getAsString() : null;
        this.partitionList = jsonObject.has("partitionList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("partitionList").spliterator(), false).map(e -> GsonElementFactory.createPartition(e.getAsJsonObject())).collect(Collectors.toList())) : Collections.emptyList();
    }

    public GsonLanguageDefImpl(String fileSuffix, List<Partition> partitionList) {
        this.fileSuffix = fileSuffix;
        this.partitionList = partitionList;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "LanguageDef");
        o.addProperty("fileSuffix", this.getFileSuffix());
        o.add("partitionList", (JsonElement)GsonBase.toDomainJsonArray(this.getPartitionList()));
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "fileSuffix : " + this.fileSuffix + ", " + "partitionList : " + this.partitionList.stream().map(e -> String.valueOf(e.getClass().getSimpleName()) + "@" + Integer.toHexString(e.hashCode())).collect(Collectors.toList()) + " }";
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public List<Partition> getPartitionList() {
        return this.partitionList;
    }

    public static class Builder
    implements LanguageDef.Builder {
        private final EditorGModel instance;
        private String fileSuffix;
        private final List<Partition> partitionList = new ArrayList<Partition>();

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder fileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        @Override
        public Builder partitionList(List<Partition> partitionList) {
            this.partitionList.addAll(partitionList);
            return this;
        }

        @Override
        public Builder appendPartitionList(Partition partitionList) {
            this.partitionList.add(partitionList);
            return this;
        }

        @Override
        public Builder partitionList(Function<EditorGModel, List<Partition>> provider) {
            this.partitionList((List)provider.apply(this.instance));
            return this;
        }

        @Override
        public Builder appendPartitionList(Function<Partition.Builder, Partition> provider) {
            this.appendPartitionList(provider.apply(new GsonPartitionImpl.Builder(this.instance)));
            return this;
        }

        @Override
        public LanguageDef build() {
            return new GsonLanguageDefImpl(this.fileSuffix, this.partitionList);
        }
    }
}

