/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.list;

import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import org.eclipse.fx.core.bindings.FXBindings;
import org.eclipse.fx.ui.controls.image.MultiDimensionImage;
import org.eclipse.fx.ui.controls.image.ScalingImageViewer;

public class ScalingImageListCell<T>
extends ListCell<T> {
    private final ScalingImageViewer imageViewer = new ScalingImageViewer();
    private final Function<T, ObservableValue<MultiDimensionImage>> imageProvider;

    public ScalingImageListCell(ListView<T> view, Function<T, ObservableValue<MultiDimensionImage>> imageProvider) {
        this.imageProvider = imageProvider;
        this.imageViewer.derivedDimensionProperty().bind((ObservableValue)FXBindings.map((ObservableValue)view.orientationProperty(), o -> o == Orientation.HORIZONTAL ? ScalingImageViewer.Dimension.WIDTH : ScalingImageViewer.Dimension.HEIGHT));
    }

    protected double computePrefHeight(double width) {
        return super.computeMinHeight(width);
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setGraphic(null);
            this.imageViewer.imageProperty().unbind();
        } else {
            this.imageViewer.imageProperty().bind(this.imageProvider.apply(item));
            this.setGraphic((Node)this.imageViewer);
        }
    }
}

