/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.Subscription;

public class FXBindUtil {
    public static <A, B> Subscription uniMapBindList(final ObservableList<A> a, ObservableList<B> b, Function<A, B> map) {
        final ListChangeListener aChange = change -> {
            while (change.next()) {
                if (change.wasPermutated()) {
                    List beforePermutate = b.subList(change.getFrom(), change.getTo());
                    int i = 0;
                    while (i < beforePermutate.size()) {
                        b.set(change.getPermutation(change.getFrom() + i), beforePermutate.get(i));
                        ++i;
                    }
                }
                if (change.wasRemoved()) {
                    b.remove(change.getFrom(), change.getFrom() + change.getRemovedSize());
                }
                if (change.wasAdded()) {
                    List added = change.getAddedSubList();
                    List addedMapped = added.stream().map(map).collect(Collectors.toList());
                    b.addAll(change.getFrom(), addedMapped);
                    continue;
                }
                if (!change.wasUpdated() && !change.wasReplaced()) continue;
                List updated = a.subList(change.getFrom(), change.getTo());
                List updatedMapped = updated.stream().map(map).collect(Collectors.toList());
                int i = 0;
                while (i < updatedMapped.size()) {
                    b.set(change.getFrom(), updatedMapped.get(i));
                    ++i;
                }
            }
        };
        a.addListener(aChange);
        return new Subscription(){

            public void dispose() {
                a.removeListener(aChange);
            }
        };
    }
}

