/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.table;

import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.jdt.annotation.NonNull;

public class TableColumnUtil {
    public static <S, T> TableColumn<S, T> createColumn(String label, double prefWidth, Function<S, T> valueExtractor) {
        TableColumn c = new TableColumn();
        c.setText(label);
        c.setPrefWidth(prefWidth);
        c.setCellValueFactory(f -> new SimpleObjectProperty(valueExtractor.apply(f.getValue())));
        return c;
    }

    public static <S, T> TableColumn<S, T> setupColumn(TableColumn<S, T> c, Function<S, T> valueExtractor) {
        c.setCellValueFactory(f -> new SimpleObjectProperty(valueExtractor.apply(f.getValue())));
        return c;
    }

    public static <S, T> TableColumn<S, T> setupColumn(TableColumn<S, T> c, Function<S, T> valueExtractor, final Function<T, @NonNull CharSequence> labelConverter) {
        c.setCellValueFactory(f -> new SimpleObjectProperty(valueExtractor.apply(f.getValue())));
        c.setCellFactory(cc -> new TableCell<S, T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setText(((CharSequence)labelConverter.apply(item)).toString());
                }
            }
        });
        return c;
    }

    public static <S> TableColumn<S, S> setupCheckboxColumn(TableView<S> view, TableColumn<S, S> c, final Function<S, BooleanProperty> booleanPropertyCreator) {
        view.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.SPACE && view.getSelectionModel().getSelectedItem() != null) {
                BooleanProperty property;
                property.set(!(property = (BooleanProperty)booleanPropertyCreator.apply(view.getSelectionModel().getSelectedItem())).get());
            }
        });
        c.setCellValueFactory(f -> new SimpleObjectProperty(f.getValue()));
        c.setCellFactory(cc -> new TableCell<S, S>(){
            private BooleanProperty modelProperty;

            protected void updateItem(S item, boolean empty) {
                super.updateItem(item, empty);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setAlignment(Pos.CENTER);
                CheckBox box = (CheckBox)this.getGraphic();
                if (box != null && this.modelProperty != null) {
                    box.selectedProperty().unbindBidirectional((Property)this.modelProperty);
                }
                if (item == null || empty) {
                    this.setGraphic(null);
                } else {
                    if (box == null) {
                        box = new CheckBox();
                        box.setFocusTraversable(false);
                        box.setAccessibleText("Select item by hitting space");
                        this.setGraphic((Node)box);
                    }
                    box.selectedProperty().bindBidirectional((Property)booleanPropertyCreator.apply(item));
                }
            }
        });
        c.setEditable(true);
        return c;
    }
}

