/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.base.rendering.AbstractRenderer;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseAreaRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuBarRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuSeparatorRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartMenuRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePerspectiveRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePerspectiveStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePlaceholderRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BasePopupMenuRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseSashRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolBarRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolBarSeparatorRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolControlRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseTrimBarRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseWindowRenderer;

public abstract class BaseWorkbenchRendererFactory
implements RendererFactory {
    public static final String SHARED_ELEMENTS_MAP = "EFX.RENDERING.SHARED_ELEMENTS_MAP";
    private IEclipseContext context;
    private BaseWindowRenderer<?> windowRenderer;
    private BaseSashRenderer<?> sashRenderer;
    private BaseMenuBarRenderer<?> menuBarRenderer;
    private BaseTrimBarRenderer<?> trimBarRenderer;
    private BaseToolBarRenderer<?> toolBarRenderer;
    private BaseToolItemRenderer<?> toolItemRenderer;
    private BaseStackRenderer<?, ?, ?> stackRenderer;
    private BasePartRenderer<?, ?, ?> partRenderer;
    private BaseMenuRenderer<?> menuRenderer;
    private BaseMenuItemRenderer<?> menuItemRenderer;
    private BaseMenuSeparatorRenderer<?> menuSeperatorRenderer;
    private BaseMenuRenderer<?> toolItemMenuRenderer;
    private BasePerspectiveStackRenderer<?, ?, ?> perspectiveStackRenderer;
    private BasePerspectiveRenderer<?> perspectiveRenderer;
    private BasePlaceholderRenderer<?> placeholderRenderer;
    private BaseToolControlRenderer<?> toolcontrolRenderer;
    private BaseToolBarSeparatorRenderer<?> toolbarSeparatorRenderer;
    private BaseAreaRenderer<?> areaRenderer;
    private BasePopupMenuRenderer<?> popupMenuRenderer;
    private BasePartMenuRenderer<?> partMenuRenderer;

    @Inject
    public BaseWorkbenchRendererFactory(IEclipseContext context) {
        this.context = context.createChild();
        this.context.set(RendererFactory.class, (Object)this);
        this.context.set(SHARED_ELEMENTS_MAP, new HashMap());
    }

    public <R extends AbstractRenderer<?, ?>> R getRenderer(MUIElement modelObject) {
        if (modelObject instanceof MPopupMenu) {
            if (this.popupMenuRenderer == null) {
                this.popupMenuRenderer = (BasePopupMenuRenderer)ContextInjectionFactory.make(this.getPopupMenuRendererClass(), (IEclipseContext)this.context);
            }
            return (R)this.popupMenuRenderer;
        }
        if (modelObject instanceof MArea) {
            if (this.areaRenderer == null) {
                this.areaRenderer = (BaseAreaRenderer)((Object)ContextInjectionFactory.make(this.getAreaRendererClass(), (IEclipseContext)this.context));
            }
            return (R)((Object)this.areaRenderer);
        }
        if (modelObject instanceof MWindow) {
            if (this.windowRenderer == null) {
                this.windowRenderer = this.make(this.getWindowRendererClass());
            }
            return (R)((Object)this.windowRenderer);
        }
        if (modelObject instanceof MPerspectiveStack) {
            if (this.perspectiveStackRenderer == null) {
                this.perspectiveStackRenderer = this.make(this.getPerspectiveStackRendererClass());
            }
            return (R)((Object)this.perspectiveStackRenderer);
        }
        if (modelObject instanceof MPerspective) {
            if (this.perspectiveRenderer == null) {
                this.perspectiveRenderer = this.make(this.getPerspectiveRendererClass());
            }
            return (R)((Object)this.perspectiveRenderer);
        }
        if (modelObject instanceof MPartSashContainer) {
            if (this.sashRenderer == null) {
                this.sashRenderer = this.make(this.getSashRendererClass());
            }
            return (R)((Object)this.sashRenderer);
        }
        if (modelObject instanceof MMenu) {
            if (BasicPackageImpl.Literals.WINDOW__MAIN_MENU.equals(((EObject)modelObject).eContainmentFeature())) {
                if (this.menuBarRenderer == null) {
                    this.menuBarRenderer = this.make(this.getMenuBarRendererClass());
                }
                return (R)this.menuBarRenderer;
            }
            if (MenuPackageImpl.Literals.TOOL_ITEM__MENU.equals(((EObject)modelObject).eContainmentFeature())) {
                if (this.toolItemMenuRenderer == null) {
                    this.toolItemMenuRenderer = this.make(this.getToolItemMenuRendererClass());
                }
                return (R)this.toolItemMenuRenderer;
            }
            if (((EObject)modelObject).eContainer() instanceof MPart && ((MMenu)modelObject).getTags().contains("ViewMenu")) {
                if (this.partMenuRenderer == null) {
                    this.partMenuRenderer = this.make(this.getPartMenuRenderer());
                }
                return (R)this.partMenuRenderer;
            }
            if (this.menuRenderer == null) {
                this.menuRenderer = this.make(this.getMenuRendererClass());
            }
            return (R)this.menuRenderer;
        }
        if (modelObject instanceof MTrimBar) {
            if (this.trimBarRenderer == null) {
                this.trimBarRenderer = this.make(this.getTrimBarRendererClass());
            }
            return (R)this.trimBarRenderer;
        }
        if (modelObject instanceof MToolBar) {
            if (this.toolBarRenderer == null) {
                this.toolBarRenderer = this.make(this.getToolBarRendererClass());
            }
            return (R)this.toolBarRenderer;
        }
        if (modelObject instanceof MToolItem) {
            if (this.toolItemRenderer == null) {
                this.toolItemRenderer = this.make(this.getToolItemRendererClass());
            }
            return (R)((Object)this.toolItemRenderer);
        }
        if (modelObject instanceof MPartStack) {
            if (this.stackRenderer == null) {
                this.stackRenderer = this.make(this.getStackRendererClass());
            }
            return (R)((Object)this.stackRenderer);
        }
        if (modelObject instanceof MPart) {
            if (this.partRenderer == null) {
                this.partRenderer = this.make(this.getPartRendererClass());
            }
            return (R)((Object)this.partRenderer);
        }
        if (modelObject instanceof MMenuItem && !(modelObject instanceof MDynamicMenuContribution)) {
            if (this.menuItemRenderer == null) {
                this.menuItemRenderer = this.make(this.getMenuItemRendererClass());
            }
            return (R)((Object)this.menuItemRenderer);
        }
        if (modelObject instanceof MMenuSeparator) {
            if (this.menuSeperatorRenderer == null) {
                this.menuSeperatorRenderer = this.make(this.getMenuSeparatorRendererClass());
            }
            return (R)((Object)this.menuSeperatorRenderer);
        }
        if (modelObject instanceof MPlaceholder) {
            if (this.placeholderRenderer == null) {
                this.placeholderRenderer = this.make(this.getPlaceholderRendererClass());
            }
            return (R)((Object)this.placeholderRenderer);
        }
        if (modelObject instanceof MToolControl) {
            if (this.toolcontrolRenderer == null) {
                this.toolcontrolRenderer = this.make(this.getToolcontrolRendererClass());
            }
            return (R)((Object)this.toolcontrolRenderer);
        }
        if (modelObject instanceof MToolBarSeparator) {
            if (this.toolbarSeparatorRenderer == null) {
                this.toolbarSeparatorRenderer = this.make(this.getToolBarSeparatorRendererClass());
            }
            return (R)((Object)this.toolbarSeparatorRenderer);
        }
        return null;
    }

    protected <R extends AbstractRenderer<?, ?>> R make(Class<R> rendererClass) {
        return (R)((AbstractRenderer)ContextInjectionFactory.make(rendererClass, (IEclipseContext)this.context));
    }

    protected abstract Class<? extends BaseWindowRenderer<?>> getWindowRendererClass();

    protected abstract Class<? extends BaseSashRenderer<?>> getSashRendererClass();

    protected abstract Class<? extends BaseMenuBarRenderer<?>> getMenuBarRendererClass();

    protected abstract Class<? extends BaseTrimBarRenderer<?>> getTrimBarRendererClass();

    protected abstract Class<? extends BaseToolBarRenderer<?>> getToolBarRendererClass();

    protected abstract Class<? extends BaseToolItemRenderer<?>> getToolItemRendererClass();

    protected abstract Class<? extends BaseStackRenderer<?, ?, ?>> getStackRendererClass();

    protected abstract Class<? extends BasePartRenderer<?, ?, ?>> getPartRendererClass();

    protected abstract Class<? extends BaseMenuRenderer<?>> getMenuRendererClass();

    protected abstract Class<? extends BaseMenuItemRenderer<?>> getMenuItemRendererClass();

    protected abstract Class<? extends BaseMenuSeparatorRenderer<?>> getMenuSeparatorRendererClass();

    protected abstract Class<? extends BaseMenuRenderer<?>> getToolItemMenuRendererClass();

    protected abstract Class<? extends BasePerspectiveStackRenderer<?, ?, ?>> getPerspectiveStackRendererClass();

    protected abstract Class<? extends BasePerspectiveRenderer<?>> getPerspectiveRendererClass();

    protected abstract Class<? extends BasePlaceholderRenderer<?>> getPlaceholderRendererClass();

    protected abstract Class<? extends BaseToolControlRenderer<?>> getToolcontrolRendererClass();

    protected abstract Class<? extends BaseToolBarSeparatorRenderer<?>> getToolBarSeparatorRendererClass();

    protected abstract Class<? extends BaseAreaRenderer<?>> getAreaRendererClass();

    protected abstract Class<? extends BasePopupMenuRenderer<?>> getPopupMenuRendererClass();

    protected abstract Class<? extends BasePartMenuRenderer<?>> getPartMenuRenderer();
}

