/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.function.Supplier;
import javafx.scene.Node;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class CompletetionProposal
implements ICompletionProposal {
    private final CharSequence label;
    private final String replacementString;
    private final int replacementOffset;
    private final int replacementLength;
    private final int cursorPosition;
    private final Supplier<Node> graphicSupplier;

    public CompletetionProposal(String replacementString, int replacementOffset, int replacementLength, CharSequence label, Supplier<Node> graphicSupplier) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = replacementString.length();
        this.label = label;
        this.graphicSupplier = graphicSupplier;
    }

    @Override
    public Node getGraphic() {
        return this.graphicSupplier.get();
    }

    @Override
    public CharSequence getLabel() {
        return this.label;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TextSelection getSelection(IDocument document) {
        return new TextSelection(this.replacementOffset + this.cursorPosition, 0);
    }
}

