/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.vectorgraphics;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.VLineTo;
import org.eclipse.jdt.annotation.NonNull;

public class PathUtils {
    public static void parseSVGPath(String svgPath, PathHandler h) {
        new SVGParser(svgPath).parse(h);
    }

    public static @NonNull List<@NonNull PathElement> transformToPathElements(String svgPath) {
        final ArrayList<Object> l = new ArrayList<Object>();
        if (svgPath.indexOf(84) != -1 || svgPath.indexOf(116) != -1 || svgPath.indexOf(83) != -1 || svgPath.indexOf(115) != -1) {
            Path2D p = new Path2D();
            p.appendSVGPath(svgPath);
            PathIterator pathIterator = p.getPathIterator(null);
            float[] coords = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(coords)) {
                    case 0: {
                        l.add(new MoveTo((double)coords[0], (double)coords[1]));
                        break;
                    }
                    case 1: {
                        l.add(new LineTo((double)coords[0], (double)coords[1]));
                        break;
                    }
                    case 2: {
                        l.add(new QuadCurveTo((double)coords[0], (double)coords[1], (double)coords[2], (double)coords[3]));
                        break;
                    }
                    case 3: {
                        l.add(new CubicCurveTo((double)coords[0], (double)coords[1], (double)coords[0], (double)coords[1], (double)coords[0], (double)coords[1]));
                        break;
                    }
                    case 4: {
                        l.add(new ClosePath());
                        break;
                    }
                }
            }
        } else {
            new SVGParser(svgPath).parse(new PathHandler(){

                @Override
                public void vlineToRel(double y) {
                    l.add(PathUtils.makeAbsolute(false, new VLineTo(y)));
                }

                @Override
                public void vlineToAbs(double y) {
                    l.add(PathUtils.makeAbsolute(true, new VLineTo(y)));
                }

                @Override
                public void squadCurveToRel(double x, double y) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void squadCurveToAbs(double x, double y) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void scurveToRel(double x2, double y2, double x, double y) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void scurveToAbs(double x2, double y2, double x, double y) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void quadCurveToRel(double x1, double y1, double x, double y) {
                    l.add(PathUtils.makeAbsolute(false, new QuadCurveTo(x1, y1, x, y)));
                }

                @Override
                public void quadCurveToAbs(double x1, double y1, double x, double y) {
                    l.add(PathUtils.makeAbsolute(true, new QuadCurveTo(x1, y1, x, y)));
                }

                @Override
                public void moveToRel(double x, double y) {
                    l.add(PathUtils.makeAbsolute(false, new MoveTo(x, y)));
                }

                @Override
                public void moveToAbs(double x, double y) {
                    l.add(PathUtils.makeAbsolute(true, new MoveTo(x, y)));
                }

                @Override
                public void lineToRel(double x, double y) {
                    l.add(PathUtils.makeAbsolute(false, new LineTo(x, y)));
                }

                @Override
                public void lineToAbs(double x, double y) {
                    l.add(PathUtils.makeAbsolute(true, new LineTo(x, y)));
                }

                @Override
                public void hlineToRel(double x) {
                    l.add(PathUtils.makeAbsolute(false, new HLineTo(x)));
                }

                @Override
                public void hlineToAbs(double x) {
                    l.add(PathUtils.makeAbsolute(true, new HLineTo(x)));
                }

                @Override
                public void error(String error) {
                }

                @Override
                public void curveToRel(double x1, double y1, double x2, double y2, double x, double y) {
                    l.add(PathUtils.makeAbsolute(false, new CubicCurveTo(x1, y1, x2, y2, x, y)));
                }

                @Override
                public void curveToAbs(double x1, double y1, double x2, double y2, double x, double y) {
                    l.add(PathUtils.makeAbsolute(true, new CubicCurveTo(x1, y1, x2, y2, x, y)));
                }

                @Override
                public void closePathRel() {
                    l.add(PathUtils.makeAbsolute(false, new ClosePath()));
                }

                @Override
                public void closePathAbs() {
                    l.add(PathUtils.makeAbsolute(true, new ClosePath()));
                }

                @Override
                public void arcRel(double rx, double ry, double xaxisrotation, boolean largearcflag, boolean sweepflag, double x, double y) {
                    l.add(PathUtils.makeAbsolute(false, new ArcTo(rx, ry, xaxisrotation, x, y, largearcflag, sweepflag)));
                }

                @Override
                public void arcAbs(double rx, double ry, double xaxisrotation, boolean largearcflag, boolean sweepflag, double x, double y) {
                    l.add(PathUtils.makeAbsolute(true, new ArcTo(rx, ry, xaxisrotation, x, y, largearcflag, sweepflag)));
                }
            });
        }
        return Collections.unmodifiableList(l);
    }

    static <P extends PathElement> P makeAbsolute(boolean absolute, P element) {
        element.setAbsolute(absolute);
        return element;
    }

    public static interface PathHandler {
        public void moveToAbs(double var1, double var3);

        public void moveToRel(double var1, double var3);

        public void error(String var1);

        public void curveToRel(double var1, double var3, double var5, double var7, double var9, double var11);

        public void curveToAbs(double var1, double var3, double var5, double var7, double var9, double var11);

        public void closePathRel();

        public void closePathAbs();

        public void arcRel(double var1, double var3, double var5, boolean var7, boolean var8, double var9, double var11);

        public void arcAbs(double var1, double var3, double var5, boolean var7, boolean var8, double var9, double var11);

        public void quadCurveToRel(double var1, double var3, double var5, double var7);

        public void quadCurveToAbs(double var1, double var3, double var5, double var7);

        public void vlineToRel(double var1);

        public void vlineToAbs(double var1);

        public void hlineToRel(double var1);

        public void hlineToAbs(double var1);

        public void lineToRel(double var1, double var3);

        public void lineToAbs(double var1, double var3);

        public void scurveToRel(double var1, double var3, double var5, double var7);

        public void scurveToAbs(double var1, double var3, double var5, double var7);

        public void squadCurveToRel(double var1, double var3);

        public void squadCurveToAbs(double var1, double var3);
    }

    static class SVGParser {
        private final String svgPath;
        private int currIdx = -1;
        private char lastCommand;

        SVGParser(String svgPath) {
            this.svgPath = svgPath.trim();
        }

        /*
         * Unable to fully structure code
         */
        void parse(PathHandler h) {
            this.currIdx = -1;
            data = SVGParser.findNextNonWS(this.svgPath, this.currIdx);
            if (data == null) {
                throw new IllegalStateException("Unable to find valid segment");
            }
            if (data[0] == 77 || data[0] == 109) ** GOTO lbl75
            throw new IllegalStateException("A path needs to start with a moveto command");
lbl-1000:
            // 1 sources

            {
                data = SVGParser.findNextNonWS(this.svgPath, this.currIdx);
                switch (data[0]) {
                    case 65: 
                    case 67: 
                    case 72: 
                    case 76: 
                    case 77: 
                    case 81: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 90: 
                    case 97: 
                    case 99: 
                    case 104: 
                    case 108: 
                    case 109: 
                    case 113: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 122: {
                        this.lastCommand = (char)data[0];
                        this.currIdx = data[1];
                        break;
                    }
                    default: {
                        this.currIdx = data[1] - 1;
                    }
                }
                switch (this.lastCommand) {
                    case 'M': {
                        this.parseMoveTo(false, h);
                        break;
                    }
                    case 'm': {
                        this.parseMoveTo(true, h);
                        break;
                    }
                    case 'Z': {
                        this.parseClosePath(false, h);
                        break;
                    }
                    case 'z': {
                        this.parseClosePath(true, h);
                        break;
                    }
                    case 'L': {
                        this.parseLineTo(false, h);
                        break;
                    }
                    case 'l': {
                        this.parseLineTo(true, h);
                        break;
                    }
                    case 'H': {
                        this.parseHLineTo(false, h);
                        break;
                    }
                    case 'h': {
                        this.parseHLineTo(true, h);
                        break;
                    }
                    case 'V': {
                        this.parseVLineTo(false, h);
                        break;
                    }
                    case 'v': {
                        this.parseVLineTo(true, h);
                        break;
                    }
                    case 'C': {
                        this.parseCurveTo(false, h);
                        break;
                    }
                    case 'c': {
                        this.parseCurveTo(true, h);
                        break;
                    }
                    case 'S': {
                        this.parseSCurveTo(false, h);
                        break;
                    }
                    case 's': {
                        this.parseSCurveTo(true, h);
                        break;
                    }
                    case 'Q': {
                        this.parseQuadCurveTo(false, h);
                        break;
                    }
                    case 'q': {
                        this.parseQuadCurveTo(true, h);
                        break;
                    }
                    case 'T': {
                        this.parseSQuadCurveTo(false, h);
                        break;
                    }
                    case 't': {
                        this.parseSQuadCurveTo(true, h);
                        break;
                    }
                    case 'A': {
                        this.parseArc(false, h);
                        break;
                    }
                    case 'a': {
                        this.parseArc(true, h);
                    }
                }
lbl75:
                // 22 sources

                ** while (this.currIdx + 1 < this.svgPath.length())
            }
lbl76:
            // 1 sources

        }

        private void parseLineTo(boolean relative, PathHandler h) {
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.lineToRel(x, y);
            } else {
                h.lineToAbs(x, y);
            }
        }

        private void parseHLineTo(boolean relative, PathHandler h) {
            double x = this.nextNum();
            if (relative) {
                h.hlineToRel(x);
            } else {
                h.hlineToAbs(x);
            }
        }

        private void parseVLineTo(boolean relative, PathHandler h) {
            double y = this.nextNum();
            if (relative) {
                h.vlineToRel(y);
            } else {
                h.vlineToAbs(y);
            }
        }

        private void parseQuadCurveTo(boolean relative, PathHandler h) {
            double x1 = this.nextNum();
            double y1 = this.nextNum();
            double x2 = this.nextNum();
            double y2 = this.nextNum();
            if (relative) {
                h.quadCurveToRel(x1, y1, x2, y2);
            } else {
                h.quadCurveToAbs(x1, y1, x2, y2);
            }
        }

        private void parseSQuadCurveTo(boolean relative, PathHandler h) {
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.squadCurveToRel(x, y);
            } else {
                h.squadCurveToAbs(x, y);
            }
        }

        private void parseArc(boolean relative, PathHandler h) {
            double rx = this.nextNum();
            double ry = this.nextNum();
            double xaxisrotation = this.nextNum();
            boolean largearcflag = this.nextNum() == 1.0;
            boolean sweepflag = this.nextNum() == 1.0;
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.arcRel(rx, ry, xaxisrotation, largearcflag, sweepflag, x, y);
            } else {
                h.arcAbs(rx, ry, xaxisrotation, largearcflag, sweepflag, x, y);
            }
        }

        private void parseClosePath(boolean relative, PathHandler h) {
            ++this.currIdx;
            if (relative) {
                h.closePathRel();
            } else {
                h.closePathAbs();
            }
        }

        private void parseMoveTo(boolean relative, PathHandler h) {
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.moveToRel(x, y);
            } else {
                h.moveToAbs(x, y);
            }
        }

        private void parseCurveTo(boolean relative, PathHandler h) {
            double x1 = this.nextNum();
            double y1 = this.nextNum();
            double x2 = this.nextNum();
            double y2 = this.nextNum();
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.curveToRel(x1, y1, x2, y2, x, y);
            } else {
                h.curveToAbs(x1, y1, x2, y2, x, y);
            }
        }

        private void parseSCurveTo(boolean relative, PathHandler h) {
            double x2 = this.nextNum();
            double y2 = this.nextNum();
            double x = this.nextNum();
            double y = this.nextNum();
            if (relative) {
                h.scurveToRel(x2, y2, x, y);
            } else {
                h.scurveToAbs(x2, y2, x, y);
            }
        }

        private double nextNum() {
            char c;
            while (this.currIdx + 1 < this.svgPath.length() && (Character.isWhitespace(this.svgPath.charAt(this.currIdx + 1)) || this.svgPath.charAt(this.currIdx + 1) == ',')) {
                ++this.currIdx;
            }
            StringBuilder num = new StringBuilder();
            while (this.currIdx + 1 < this.svgPath.length() && ((c = this.svgPath.charAt(this.currIdx + 1)) == '.' || c == 'e' || c == 'E' || c == '-' || c == '+' || Character.isDigit(c))) {
                num.append(c);
                ++this.currIdx;
            }
            return Double.parseDouble(num.toString());
        }

        private static int[] findNextNonWS(String path, int currIdx) {
            int idx = currIdx;
            while (++idx < path.length()) {
                char charAt = path.charAt(idx);
                if (Character.isWhitespace(charAt)) continue;
                return new int[]{charAt, idx};
            }
            return null;
        }
    }
}

