/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Map;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public abstract class CustomTypeParameterSubstitutor
extends TypeParameterSubstitutor<ConstraintVisitingInfo> {
    protected CustomTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner) {
        super(typeParameterMapping, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ConstraintVisitingInfo visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)type;
            if (!visiting.tryVisit(typeParameter)) {
                if (!this.isDeclaredTypeParameter(typeParameter)) {
                    if (visiting.getCurrentDeclarator() != null) {
                        LightweightTypeReference mappedReference = this.getDeclaredUpperBound(visiting.getCurrentDeclarator(), visiting.getCurrentIndex(), visiting);
                        this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                        return mappedReference;
                    }
                    LightweightMergedBoundTypeArgument candidate = this.getTypeParameterMapping().get(typeParameter);
                    if (candidate != null && candidate.getTypeReference() != null) {
                        return candidate.getTypeReference();
                    }
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(typeParameter, visiting);
                    if (mappedReference == null) {
                        mappedReference = this.getObjectReference();
                    }
                    this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    return mappedReference;
                }
            } else {
                try {
                    LightweightMergedBoundTypeArgument boundTypeArgument = this.getBoundTypeArgument(typeParameter, visiting);
                    if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                        WildcardTypeReference wildcard;
                        LightweightTypeReference result = boundTypeArgument.getTypeReference().accept(this, visiting);
                        if (boundTypeArgument.getVariance() == VarianceInfo.OUT) {
                            wildcard = this.getOwner().newWildcardTypeReference();
                            wildcard.addUpperBound(result.getInvariantBoundSubstitute());
                            result = wildcard;
                        } else if (boundTypeArgument.getVariance() == VarianceInfo.IN) {
                            wildcard = this.getOwner().newWildcardTypeReference();
                            wildcard.addUpperBound(this.getObjectReference());
                            wildcard.setLowerBound(result.getInvariantBoundSubstitute());
                            result = wildcard;
                        }
                        LightweightTypeReference lightweightTypeReference = result;
                        return lightweightTypeReference;
                    }
                    LightweightTypeReference mappedReference = this.getUnmappedSubstitute(reference, (JvmTypeParameter)type, visiting);
                    if (mappedReference != null) {
                        this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                        LightweightTypeReference lightweightTypeReference = mappedReference;
                        return lightweightTypeReference;
                    }
                }
                finally {
                    visiting.didVisit(typeParameter);
                }
            }
        }
        return this.doVisitParameterizedTypeReference(reference, type, visiting);
    }

    @Override
    protected LightweightTypeReference enhanceParameterizedTypeReference(ParameterizedTypeReference origin, JvmType type, ParameterizedTypeReference result, ConstraintVisitingInfo visiting) {
        for (int i = 0; i < origin.getTypeArguments().size(); ++i) {
            LightweightTypeReference argument = origin.getTypeArguments().get(i);
            visiting.pushInfo(type instanceof JvmTypeParameterDeclarator ? (JvmTypeParameterDeclarator)type : null, i);
            LightweightTypeReference visitedArgument = this.visitTypeArgument(argument, visiting);
            result.addTypeArgument(visitedArgument);
        }
        return result;
    }

    protected boolean isDeclaredTypeParameter(JvmTypeParameter typeParameter) {
        return this.getOwner().getDeclaredTypeParameters().contains(typeParameter);
    }

    protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter type, ConstraintVisitingInfo info) {
        return this.getTypeParameterMapping().get(type);
    }

    protected abstract LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference var1, JvmTypeParameter var2, ConstraintVisitingInfo var3);

    protected LightweightTypeReference getDeclaredUpperBound(JvmTypeParameterDeclarator type, int parameterIndex, ConstraintVisitingInfo visiting) {
        JvmTypeParameter typeParameter;
        LightweightTypeReference result;
        if (type != null && type.getTypeParameters().size() > parameterIndex && (result = this.getDeclaredUpperBound(typeParameter = (JvmTypeParameter)type.getTypeParameters().get(parameterIndex), visiting)) != null) {
            return result;
        }
        return this.getObjectReference();
    }

    protected LightweightTypeReference getObjectReference() {
        return this.getOwner().newReferenceToObject();
    }

    protected LightweightTypeReference getDeclaredUpperBound(JvmTypeParameter typeParameter, ConstraintVisitingInfo visiting) {
        JvmTypeConstraint constraint;
        if (!typeParameter.getConstraints().isEmpty() && (constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0)) instanceof JvmUpperBound) {
            LightweightTypeReference reference = this.getOwner().toLightweightTypeReference(constraint.getTypeReference());
            if (visiting.getCurrentDeclarator() != reference.getType()) {
                return this.visitTypeArgument(reference, visiting);
            }
            WildcardTypeReference result = this.getOwner().newWildcardTypeReference();
            result.addUpperBound(this.getObjectReference());
            return result;
        }
        return null;
    }

    @Override
    public LightweightTypeReference substitute(LightweightTypeReference original) {
        LightweightTypeReference componentType;
        if (original instanceof ArrayTypeReference && (componentType = original.getComponentType()) instanceof UnboundTypeReference) {
            LightweightTypeReference substitutedComponentType = this.substitute(componentType);
            return this.getOwner().newArrayTypeReference(substitutedComponentType);
        }
        if (original instanceof UnboundTypeReference) {
            ConstraintVisitingInfo visitingInfo = this.createVisiting();
            JvmTypeParameter typeParameter = ((UnboundTypeReference)original).getTypeParameter();
            JvmTypeParameterDeclarator declarator = typeParameter.getDeclarator();
            visitingInfo.pushInfo(declarator, declarator.getTypeParameters().indexOf((Object)typeParameter));
            LightweightTypeReference result = this.visitTypeArgument(original, visitingInfo);
            return result;
        }
        LightweightTypeReference result = original.accept(this, this.createVisiting());
        return result;
    }

    @Override
    protected ConstraintVisitingInfo createVisiting() {
        return new ConstraintVisitingInfo();
    }

    protected ConstraintVisitingInfo createVisiting(JvmTypeParameter initialValue) {
        ConstraintVisitingInfo result = this.createVisiting();
        result.tryVisit(initialValue);
        return result;
    }
}

