/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation;

import javafx.animation.Transition;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class ScaleTransition
extends Transition {
    private double startX = Double.NaN;
    private double startY = Double.NaN;
    private double startZ = Double.NaN;
    private double deltaX;
    private double deltaY;
    private double deltaZ;
    private final Scale scale;
    private double fromX = 1.0;
    private double toX = 1.0;
    private double fromY = 1.0;
    private double toY = 1.0;
    private double fromZ = 1.0;
    private double toZ = 1.0;

    public ScaleTransition(Duration duration, Scale scale) {
        this.scale = scale;
        this.setCycleDuration(duration);
    }

    public void setFromX(double fromX) {
        this.fromX = fromX;
        this.computeDelta();
    }

    public void setToX(double toX) {
        this.toX = toX;
        this.computeDelta();
    }

    public void setFromY(double fromY) {
        this.fromY = fromY;
        this.computeDelta();
    }

    public void setToY(double toY) {
        this.toY = toY;
        this.computeDelta();
    }

    public void setFromZ(double fromZ) {
        this.fromZ = fromZ;
        this.computeDelta();
    }

    public void setToZ(double toZ) {
        this.toZ = toZ;
        this.computeDelta();
    }

    private void computeDelta() {
        this.startX = this.fromX;
        this.startY = this.fromY;
        this.startZ = this.fromZ;
        this.deltaX = this.toX - this.fromX;
        this.deltaY = this.toY - this.fromY;
        this.deltaZ = this.toZ - this.fromZ;
    }

    protected void interpolate(double frac) {
        if (!Double.isNaN(this.startX)) {
            this.scale.setX(this.startX + frac * this.deltaX);
        }
        if (!Double.isNaN(this.startY)) {
            this.scale.setY(this.startY + frac * this.deltaY);
        }
        if (!Double.isNaN(this.startZ)) {
            this.scale.setZ(this.startZ + frac * this.deltaZ);
        }
    }
}

