/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETMark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETReader {
    protected char startTagInitialChar = (char)60;
    protected char endTagInitialChar = (char)37;
    protected char endTagFinalChar = (char)62;
    protected JETMark current = null;
    protected String master = null;
    protected List<String> sourceFiles = new ArrayList<String>();
    protected List<String> baseURIs = new ArrayList<String>();
    protected int size = 0;
    protected boolean trimExtraNewLine = true;

    public JETReader(String baseURI, String locationURI, InputStream inputStream, String encoding) throws JETException {
        this.stackStream(baseURI, locationURI, inputStream, encoding);
    }

    public JETReader(String locationURI, InputStream inputStream, String encoding) throws JETException {
        this(null, locationURI, inputStream, encoding);
    }

    public String getFile(int fileid) {
        return this.sourceFiles.get(fileid);
    }

    public String getBaseURI(int fileid) {
        return this.baseURIs.get(fileid);
    }

    public void stackStream(String locationURI, InputStream iStream, String encoding) throws JETException {
        this.stackStream(null, locationURI, iStream, encoding);
    }

    public void stackStream(String baseURI, String locationURI, InputStream iStream, String encoding) throws JETException {
        InputStreamReader reader = null;
        try {
            try {
                if (encoding == null) {
                    encoding = "UTF8";
                }
                int fileid = this.registerSourceFile(locationURI);
                this.registerBaseURI(baseURI);
                reader = new InputStreamReader(iStream, encoding);
                CharArrayWriter writer = new CharArrayWriter();
                char[] buf = new char[1024];
                int i = 0;
                while ((i = reader.read(buf)) != -1) {
                    if (buf[0] == '\ufeff') {
                        writer.write(buf, 1, i - 1);
                        continue;
                    }
                    writer.write(buf, 0, i);
                }
                writer.close();
                if (this.current == null) {
                    this.current = new JETMark(this, writer.toCharArray(), fileid, locationURI, encoding);
                } else {
                    this.current.pushStream(writer.toCharArray(), fileid, locationURI, encoding);
                }
            }
            catch (UnsupportedEncodingException exception) {
                throw new JETException(exception);
            }
            catch (IOException exception) {
                throw new JETException(exception);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    throw new JETException(exception);
                }
            }
        }
    }

    public boolean popFile() {
        if (this.current == null) {
            return false;
        }
        --this.size;
        return this.current.popStream();
    }

    protected int registerSourceFile(String file) {
        this.sourceFiles.add(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected void registerBaseURI(String baseURI) {
        this.baseURIs.add(baseURI);
    }

    public boolean hasMoreInput() {
        if (this.current.cursor < this.current.stream.length) {
            return true;
        }
        boolean nl = this.hasTrailingNewLine();
        while (this.popFile()) {
            if (this.current.cursor >= this.current.stream.length) continue;
            if (this.trimExtraNewLine && nl) {
                this.skipNewLine();
            }
            return true;
        }
        return false;
    }

    protected boolean hasTrailingNewLine() {
        char[] stream = this.current.stream;
        int i = stream.length - 1;
        while (i >= 0) {
            if (stream[i] == '\n' || stream[i] == '\r') {
                return true;
            }
            if (stream[i] != ' ') {
                return false;
            }
            --i;
        }
        return false;
    }

    protected void skipNewLine() {
        char[] stream = this.current.stream;
        int c = this.current.cursor;
        if (stream.length > c + 1 && (stream[c] == '\n' && stream[c + 1] == '\r' || stream[c] == '\r' && stream[c + 1] == '\n')) {
            this.current.cursor += 2;
            ++this.current.line;
            this.current.col = stream[0] == '\n' ? 1 : 0;
        } else if (stream.length > c && (stream[c] == '\n' || stream[c] == '\r')) {
            ++this.current.cursor;
            ++this.current.line;
            this.current.col = 0;
        }
    }

    public int nextChar() {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     */
    public String nextContent() {
        cur_cursor = this.current.cursor;
        len = this.current.stream.length;
        if (cur_cursor != len) ** GOTO lbl10
        return "";
lbl-1000:
        // 1 sources

        {
            if (ch == '\n') {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
lbl10:
            // 3 sources

            ** while (++this.current.cursor < len && (ch = this.current.stream[this.current.cursor]) != this.startTagInitialChar)
        }
lbl11:
        // 1 sources

        return new String(this.current.stream, cur_cursor, this.current.cursor - cur_cursor);
    }

    public char[] getChars(JETMark start, JETMark stop) {
        JETMark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter writer = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            writer.write(this.nextChar());
        }
        writer.close();
        this.reset(oldstart);
        return writer.toCharArray();
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public JETMark mark() {
        return new JETMark(this.current);
    }

    public void reset(JETMark mark) {
        this.current = new JETMark(mark);
    }

    public boolean matchesIgnoreCase(String string) {
        JETMark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if (Character.toLowerCase((char)(ch = this.nextChar())) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) {
        JETMark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if ((char)(ch = this.nextChar()) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public void advance(int n) {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() {
        int i = 0;
        while (this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public JETMark skipUntil(String limit) {
        JETMark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block4: {
                if (ch == limit.charAt(0)) {
                    int i = 1;
                    while (i < limlen) {
                        if (Character.toLowerCase((char)this.nextChar()) == limit.charAt(i)) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    protected boolean isSpace() {
        return this.peekChar() <= 32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean quoted) throws JETException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int ch = this.peekChar();
        if (quoted) {
            if (ch != 34 && ch != 39) throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.attr.quoted", new Object[]{this.mark().toString()}));
            int endQuote = ch == 34 ? 34 : 39;
            ch = this.nextChar();
            ch = this.nextChar();
            while (ch != -1 && ch != endQuote) {
                if (ch == 92) {
                    ch = this.nextChar();
                }
                stringBuffer.append((char)ch);
                ch = this.nextChar();
            }
            if (ch != -1) return stringBuffer.toString();
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.quotes.unterminated", new Object[]{this.mark().toString()}));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((ch = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == this.endTagFinalChar || this.peekChar() == this.endTagInitialChar)) {
                ch = this.nextChar();
            }
            stringBuffer.append((char)ch);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    protected void parseAttributeValue(HashMap<String, String> into) throws JETException {
        this.skipSpaces();
        String name = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.attr.novalue", new Object[]{name, this.mark().toString()}));
        }
        this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true);
        this.skipSpaces();
        into.put(name, value);
    }

    public HashMap<String, String> parseTagAttributesBean() throws JETException {
        HashMap<String, String> values = new HashMap<String, String>(11);
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == this.endTagFinalChar) {
                return values;
            }
            if (ch == 47) {
                JETMark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == this.endTagFinalChar) {
                        HashMap<String, String> hashMap = values;
                        return hashMap;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.tag.attr.unterminated", new Object[]{this.mark().toString()}));
    }

    public HashMap<String, String> parseTagAttributes() throws JETException {
        HashMap<String, String> values = new HashMap<String, String>(11);
        while (true) {
            int ch;
            block17: {
                JETMark mark;
                this.skipSpaces();
                ch = this.peekChar();
                if (ch == this.endTagFinalChar) {
                    return values;
                }
                if (ch == 45) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 45 && this.nextChar() == this.endTagFinalChar) {
                            HashMap<String, String> hashMap = values;
                            return hashMap;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == this.endTagInitialChar) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == this.endTagFinalChar) {
                            HashMap<String, String> hashMap = values;
                            return hashMap;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 47) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == this.endTagFinalChar) {
                            HashMap<String, String> hashMap = values;
                            return hashMap;
                        }
                    }
                    finally {
                        this.reset(mark);
                    }
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.tag.attr.unterminated", new Object[]{this.mark().toString()}));
    }

    protected boolean isDelimiter() {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == 61 || ch == this.endTagFinalChar || ch == 34 || ch == 39 || ch == 47) {
                return true;
            }
            if (ch == 45) {
                JETMark mark = this.mark();
                ch = this.nextChar();
                if (ch == this.endTagFinalChar || ch == 45 && this.nextChar() == this.endTagFinalChar) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    public void setStartTag(String startTag) {
        this.startTagInitialChar = startTag.charAt(0);
    }

    public void setEndTag(String endTag) {
        this.endTagFinalChar = endTag.charAt(endTag.length() - 1);
        this.endTagInitialChar = endTag.charAt(0);
    }
}

