/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;

public class SashPane
extends Region {
    private static final String USER_AGENT_STYLESHEET = SashPane.class.getResource("sash-pane.css").toExternalForm();
    private static final String LAYOUT_KEY = "sashData";
    static final int DRAG_MINIMUM = 20;
    private boolean syncInProgress;
    private Sash[] sashes = new Sash[0];
    private BooleanProperty horizontal = new SimpleBooleanProperty((Object)this, "horizontal", true){

        protected void invalidated() {
            super.invalidated();
            SashPane.this.clearCache();
        }
    };
    private ObjectProperty<Node> maximizedControl = new SimpleObjectProperty<Node>((Object)this, "maximizedControl"){

        protected void invalidated() {
            super.invalidated();
            SashPane.this.clearCache();
        }
    };
    private static final CssMetaData<SashPane, Number> SASH_WIDTH = new CssMetaData<SashPane, Number>("-fx-sash-width", StyleConverter.getSizeConverter(), (Number)8){

        public boolean isSettable(SashPane node) {
            return !node.sashWidthProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(SashPane node) {
            return (StyleableProperty)node.sashWidthProperty();
        }
    };
    private final @NonNull IntegerProperty sashWidth = new SimpleStyleableIntegerProperty(SASH_WIDTH, (Object)this, "sashWidth", Integer.valueOf(8));
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private ObservableList<Node> items = FXCollections.observableArrayList();
    private Sash draggedSash;
    private Node c1;
    private Node c2;
    private double resize_1;
    private double resize_2;
    private double start;
    private Bounds clientArea;
    private double resize_total;
    private static PseudoClass HORIZONTAL;
    private static PseudoClass VERTICAL;
    private ObjectProperty<int[]> weights = null;

    static {
        ArrayList<CssMetaData<SashPane, Number>> styleables = new ArrayList<CssMetaData<SashPane, Number>>(Region.getClassCssMetaData());
        styleables.add(SASH_WIDTH);
        STYLEABLES = Collections.unmodifiableList(styleables);
        HORIZONTAL = PseudoClass.getPseudoClass((String)"horizontal");
        VERTICAL = PseudoClass.getPseudoClass((String)"vertical");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SashPane.getClassCssMetaData();
    }

    public SashPane() {
        this.getStyleClass().add((Object)"sash-pane");
        this.items.addListener(c -> {
            while (c.next()) {
                if (c.wasRemoved()) {
                    this.getChildren().removeIf(n -> {
                        boolean rv;
                        boolean bl = rv = n instanceof SashChild && c.getRemoved().contains(((SashChild)((Object)((Object)n))).getChildren().get(0));
                        if (rv) {
                            ((SashChild)((Object)((Object)n))).dispose();
                        }
                        return rv;
                    });
                }
                if (!c.wasAdded()) continue;
                this.getChildren().addAll(c.getFrom(), (Collection)c.getAddedSubList().stream().map(SashChild::new).collect(Collectors.toList()));
            }
            this.clearCache();
        });
        this.sashWidth.addListener(o -> {
            this.clearCache();
            this.requestLayout();
        });
        this.pseudoClassStateChanged(HORIZONTAL, true);
        this.pseudoClassStateChanged(VERTICAL, false);
        this.horizontal.addListener((o, ol, ne) -> {
            this.pseudoClassStateChanged(HORIZONTAL, (boolean)ne);
            this.pseudoClassStateChanged(VERTICAL, ne == false);
        });
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    void clearCache() {
        this.clientArea = null;
    }

    protected void layoutChildren() {
        this.layoutChildren(false);
    }

    private boolean hasFixedChild() {
        return this.getManagedChildren().stream().filter(Node::isVisible).map(SashChild.class::cast).filter(SashChild::isFixed).findAny().isPresent();
    }

    void layoutChildren(boolean force) {
        int i;
        Sash[] newSashes;
        int x = (int)Math.ceil(this.getPadding().getLeft());
        int y = (int)Math.ceil(this.getPadding().getTop());
        int w = (int)Math.floor(this.getWidth()) - (int)Math.ceil(this.getPadding().getLeft()) - (int)Math.ceil(this.getPadding().getRight());
        int h = (int)Math.floor(this.getHeight()) - (int)Math.ceil(this.getPadding().getTop()) - (int)Math.ceil(this.getPadding().getBottom());
        boolean hasFixedChild = this.hasFixedChild();
        BoundingBox b = new BoundingBox((double)x, (double)y, (double)w, (double)h);
        if (!force && this.clientArea != null && this.clientArea.equals(b) && !hasFixedChild) {
            return;
        }
        if (w <= 1 || h <= 1) {
            return;
        }
        List children = this.getManagedChildren().stream().filter(Node::isVisible).collect(Collectors.toList());
        if (children.isEmpty()) {
            return;
        }
        if (this.maximizedControl.get() != null && children.contains(this.maximizedControl.get())) {
            int i2 = 0;
            while (i2 < children.size()) {
                if (children.get(i2) != this.maximizedControl.get()) {
                    ((Node)children.get(i2)).resizeRelocate(0.0, 0.0, 0.0, 0.0);
                } else {
                    ((Node)children.get(i2)).resizeRelocate((double)x, (double)y, (double)h, (double)w);
                }
                ++i2;
            }
            return;
        }
        if (this.sashes.length < children.size() - 1) {
            newSashes = new Sash[children.size() - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            i = this.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = this.createSash();
                ++i;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > children.size() - 1) {
            if (children.size() == 0) {
                int i3 = 0;
                while (i3 < this.sashes.length) {
                    this.getChildren().remove((Object)this.sashes[i3]);
                    ++i3;
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[children.size() - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                i = children.size() - 1;
                while (i < this.sashes.length) {
                    this.getChildren().remove((Object)this.sashes[i]);
                    ++i;
                }
                this.sashes = newSashes;
            }
        }
        if (!this.hasFixedChild()) {
            this.layoutSimple(x, y, w, h);
        } else {
            this.layoutWithFixedChild(x, y, w, h, force);
        }
        this.clientArea = b;
        this.syncWeightProperty();
    }

    private void layoutWithFixedChild(int _x, int _y, int _w, int _h, boolean force) {
        int x = _x;
        int y = _y;
        int w = _w;
        int h = _h;
        List children = this.getManagedChildren().stream().filter(Node::isVisible).map(SashChild.class::cast).collect(Collectors.toList());
        if (children.size() == 2) {
            Node startNode = (Node)children.get(0);
            Node endNode = (Node)children.get(1);
            if (((SashChild)((Object)children.get(0))).isFixed()) {
                if (this.horizontal.get()) {
                    double minWidth = startNode.minWidth((double)h);
                    startNode.resizeRelocate((double)x, (double)y, (double)w, minWidth);
                    x = (int)((double)x + minWidth);
                    this.sashes[0].resizeRelocate(x, y, this.getSashWidth(), h);
                    endNode.resizeRelocate((double)(x += this.getSashWidth()), (double)y, (double)(w - x), (double)h);
                } else {
                    double minHeight = startNode.minHeight((double)w);
                    startNode.resizeRelocate((double)x, (double)y, (double)w, minHeight);
                    y = (int)((double)y + minHeight);
                    this.sashes[0].resizeRelocate(x, y, w, this.getSashWidth());
                    endNode.resizeRelocate((double)x, (double)(y += this.getSashWidth()), (double)w, (double)(h - y));
                }
            } else if (this.horizontal.get()) {
                double minWidth = endNode.minWidth((double)h);
                double sashWidth = this.getSashWidth();
                startNode.resizeRelocate((double)x, (double)y, (double)w - minWidth - sashWidth, (double)h);
                x = (int)((double)x + ((double)w - minWidth - sashWidth));
                this.sashes[0].resizeRelocate(x, y, sashWidth, h);
                x = (int)((double)x + sashWidth);
                endNode.resizeRelocate((double)x, (double)y, minWidth, (double)h);
            } else {
                double minHeight = endNode.minHeight((double)w);
                double sashHeight = this.getSashWidth();
                startNode.resizeRelocate((double)x, (double)y, (double)w, (double)h - minHeight - sashHeight);
                y = (int)((double)y + ((double)h - minHeight - sashHeight));
                this.sashes[0].resizeRelocate(x, y, w, sashHeight);
                y = (int)((double)y + sashHeight);
                endNode.resizeRelocate((double)x, (double)y, (double)w, minHeight);
            }
        } else {
            this.layoutWithFixedChildComplex(_x, _y, _w, _h, force);
        }
    }

    private void layoutWithFixedChildComplex(int _x, int _y, int _w, int _h, boolean force) {
        int x = _x;
        int y = _y;
        int w = _w;
        int h = _h;
        List children = this.getManagedChildren().stream().filter(Node::isVisible).map(SashChild.class::cast).collect(Collectors.toList());
        long[] ratios = new long[children.size()];
        long total = 0L;
        int i = 0;
        while (i < children.size()) {
            if (!((SashChild)((Object)children.get(i))).isFixed()) {
                Object data = ((SashChild)((Object)children.get(i))).getProperties().get((Object)LAYOUT_KEY);
                if (data != null && data instanceof SashFormData) {
                    ratios[i] = ((SashFormData)data).weight;
                } else {
                    data = new SashFormData();
                    ((SashChild)((Object)children.get(i))).getProperties().put((Object)LAYOUT_KEY, data);
                    ratios[i] = 13108L;
                    ((SashFormData)data).weight = 13108L;
                }
                total += ratios[i];
            }
            ++i;
        }
        if (this.horizontal.get()) {
            w = (int)((double)w - children.stream().filter(SashChild::isFixed).mapToDouble(s -> SashPane.computeFixedWidth(s, _h)).sum());
            double sashSize = this.getSashWidth();
            int i2 = 0;
            while (i2 < children.size()) {
                SashChild sashChild = (SashChild)((Object)children.get(i2));
                int ratioWidth = (int)((double)ratios[i2] * ((double)h - (double)this.sashes.length * sashSize) / (double)total);
                if (i2 > 0) {
                    this.sashes[i2 - 1].resizeRelocate(x, y, sashSize, h);
                    x = (int)((double)x + sashSize);
                }
                if (sashChild.isFixed()) {
                    int targetWidth = (int)SashPane.computeFixedWidth(sashChild, h);
                    sashChild.resizeRelocate(x, y, targetWidth, h);
                    x += targetWidth;
                } else {
                    sashChild.resizeRelocate(x, y, ratioWidth, h);
                    x += ratioWidth;
                }
                ++i2;
            }
        } else {
            h = (int)((double)h - children.stream().filter(SashChild::isFixed).mapToDouble(s -> SashPane.computeFixedHeight(s, _w)).sum());
            double sashSize = this.getSashWidth();
            int i3 = 0;
            while (i3 < children.size()) {
                SashChild sashChild = (SashChild)((Object)children.get(i3));
                int ratioHeight = (int)((double)ratios[i3] * ((double)h - (double)this.sashes.length * sashSize) / (double)total);
                if (i3 > 0) {
                    this.sashes[i3 - 1].resizeRelocate(x, y, w, sashSize);
                    y = (int)((double)y + sashSize);
                }
                if (sashChild.isFixed()) {
                    int targetHeight = (int)SashPane.computeFixedHeight(sashChild, w);
                    sashChild.resizeRelocate(x, y, w, targetHeight);
                    y += targetHeight;
                } else {
                    sashChild.resizeRelocate(x, y, w, ratioHeight);
                    y += ratioHeight;
                }
                ++i3;
            }
        }
    }

    private static double computeFixedHeight(SashChild child, int width) {
        return child.minHeight(width);
    }

    private static double computeFixedWidth(SashChild child, int height) {
        return child.minWidth(height);
    }

    private static int findPrevUnfixed(List<SashChild> children, int index) {
        int i = index - 1;
        while (i >= 0) {
            if (!children.get(i).isFixed()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static int findNextUnfixed(List<SashChild> children, int index) {
        int i = index + 1;
        while (i < children.size()) {
            if (!children.get(i).isFixed()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void layoutSimple(int _x, int _y, int _w, int _h) {
        int x = _x;
        int y = _y;
        int w = _w;
        int h = _h;
        List children = this.getManagedChildren().stream().filter(Node::isVisible).collect(Collectors.toList());
        long[] ratios = new long[children.size()];
        long total = 0L;
        int i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            if (data != null && data instanceof SashFormData) {
                ratios[i] = ((SashFormData)data).weight;
            } else {
                data = new SashFormData();
                ((Node)children.get(i)).getProperties().put((Object)LAYOUT_KEY, data);
                ratios[i] = 13108L;
                ((SashFormData)data).weight = 13108L;
            }
            total += ratios[i];
            ++i;
        }
        if (this.horizontal.get()) {
            int width = (int)(ratios[0] * (long)(w - this.sashes.length * this.getSashWidth()) / total);
            ((Node)children.get(0)).resizeRelocate((double)x, (double)y, (double)width, (double)h);
            x += width;
            int i2 = 1;
            while (i2 < children.size() - 1) {
                this.sashes[i2 - 1].resizeRelocate(x, y, this.getSashWidth(), h);
                width = (int)(ratios[i2] * (long)(w - this.sashes.length * this.getSashWidth()) / total);
                ((Node)children.get(i2)).resizeRelocate((double)(x += this.getSashWidth()), (double)y, (double)width, (double)h);
                x += width;
                ++i2;
            }
            if (children.size() > 1) {
                this.sashes[this.sashes.length - 1].resizeRelocate(x, y, this.getSashWidth(), h);
                width = w - (x += this.getSashWidth());
                ((Node)children.get(children.size() - 1)).resizeRelocate((double)x, (double)y, (double)width, (double)h);
            }
        } else {
            int height = (int)(ratios[0] * (long)(h - this.sashes.length * this.getSashWidth()) / total);
            ((Node)children.get(0)).resizeRelocate((double)x, (double)y, (double)w, (double)height);
            y += height;
            int i3 = 1;
            while (i3 < children.size() - 1) {
                SashChild c = (SashChild)((Object)children.get(i3));
                this.sashes[i3 - 1].resizeRelocate(x, y, w, this.getSashWidth());
                height = (int)(ratios[i3] * (long)(h - this.sashes.length * this.getSashWidth()) / total);
                c.resizeRelocate(x, y += this.getSashWidth(), w, height);
                y += height;
                ++i3;
            }
            if (children.size() > 1) {
                this.sashes[this.sashes.length - 1].resizeRelocate(x, y, w, this.getSashWidth());
                height = h - (y += this.getSashWidth());
                ((Node)children.get(children.size() - 1)).resizeRelocate((double)x, (double)y, (double)w, (double)height);
            }
        }
    }

    private void syncWeightProperty() {
        if (this.weights != null) {
            try {
                this.syncInProgress = true;
                int[] newVal = this.getWeights();
                if (!Arrays.equals(newVal, (int[])this.weights.get())) {
                    this.weights.set((Object)newVal);
                }
            }
            finally {
                this.syncInProgress = false;
            }
        }
    }

    private void handleDragSash(MouseEvent e) {
        if (this.draggedSash == null || this.c1 == null || this.c2 == null) {
            return;
        }
        e.consume();
        if (this.hasFixedChild()) {
            if (this.getChildren().size() > 2) {
                this.handleDragFixed(e);
            }
        } else {
            this.handleDragSashSimple(e);
        }
        this.syncWeightProperty();
        this.requestLayout();
    }

    private void handleDragFixed(MouseEvent e) {
        List children = this.getManagedChildren().stream().filter(Node::isVisible).map(SashChild.class::cast).collect(Collectors.toList());
        if (this.horizontal.get()) {
            Object data2;
            Object data1;
            double w = children.stream().filter(SashChild::isFixed).mapToDouble(s -> SashPane.computeFixedHeight(s, (int)this.getWidth())).sum();
            Rectangle rectangle = new Rectangle(this.getWidth() - w, this.getHeight(), this.getInsets());
            double delta = e.getScreenX() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            long minChildWidth1 = SashPane.minChildWidth(this.c1, this.getHeight());
            long minChildWidth2 = SashPane.minChildWidth(this.c2, this.getHeight());
            if (newSize_1 < minChildWidth1) {
                newSize_2 = (long)this.resize_total - minChildWidth1;
                newSize_1 = minChildWidth1;
            }
            if (newSize_2 < minChildWidth2) {
                newSize_1 = (long)this.resize_total - minChildWidth2;
                newSize_2 = minChildWidth2;
            }
            if ((data1 = this.c1.getProperties().get((Object)LAYOUT_KEY)) == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            this.c1.resize((double)newSize_1, (double)rectangle.height);
            this.c2.resizeRelocate(this.c1.getLayoutX() + (double)newSize_1 + (double)this.getSashWidth(), this.c2.getLayoutY(), (double)newSize_2, (double)rectangle.height);
            this.draggedSash.relocate(this.c1.getLayoutX() + (double)newSize_1, this.draggedSash.getLayoutY());
        } else {
            Object data2;
            Object data1;
            double h = children.stream().filter(SashChild::isFixed).mapToDouble(s -> SashPane.computeFixedHeight(s, (int)this.getWidth())).sum();
            Rectangle rectangle = new Rectangle(this.getWidth(), this.getHeight() - h, this.getInsets());
            double delta = e.getScreenY() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            long minChildHeight1 = SashPane.minChildHeight(this.c1, this.getWidth());
            long minChildHeight2 = SashPane.minChildHeight(this.c2, this.getWidth());
            if (newSize_1 < minChildHeight1) {
                newSize_2 = (long)this.resize_total - minChildHeight1;
                newSize_1 = minChildHeight1;
            }
            if (newSize_2 < minChildHeight2) {
                newSize_1 = (long)this.resize_total - minChildHeight2;
                newSize_2 = minChildHeight2;
            }
            if ((data1 = this.c1.getProperties().get((Object)LAYOUT_KEY)) == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            this.c1.resize((double)rectangle.width, (double)newSize_1);
            this.c2.resizeRelocate(this.c2.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1 + (double)this.getSashWidth(), (double)rectangle.width, (double)newSize_2);
            this.draggedSash.relocate(this.draggedSash.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1);
        }
    }

    private static long minChildWidth(Node child, double height) {
        return Math.max((long)child.minWidth(height), 20L);
    }

    private static long minChildHeight(Node child, double width) {
        return Math.max((long)child.minHeight(width), 20L);
    }

    private void handleDragSashSimple(MouseEvent e) {
        Rectangle rectangle = new Rectangle(this.getWidth(), this.getHeight(), this.getInsets());
        if (this.horizontal.get()) {
            Object data2;
            Object data1;
            double delta = e.getScreenX() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            long minChildWidth1 = SashPane.minChildWidth(this.c1, this.getHeight());
            long minChildWidth2 = SashPane.minChildWidth(this.c2, this.getHeight());
            if (newSize_1 < minChildWidth1) {
                newSize_2 = (long)this.resize_total - minChildWidth1;
                newSize_1 = minChildWidth1;
            }
            if (newSize_2 < minChildWidth2) {
                newSize_1 = (long)this.resize_total - minChildWidth2;
                newSize_2 = minChildWidth2;
            }
            if ((data1 = this.c1.getProperties().get((Object)LAYOUT_KEY)) == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            this.c1.resize((double)newSize_1, (double)rectangle.height);
            this.c2.resizeRelocate(this.c1.getLayoutX() + (double)newSize_1 + (double)this.getSashWidth(), this.c2.getLayoutY(), (double)newSize_2, (double)rectangle.height);
            this.draggedSash.relocate(this.c1.getLayoutX() + (double)newSize_1, this.draggedSash.getLayoutY());
        } else {
            Object data2;
            Object data1;
            long remainder;
            double delta = e.getScreenY() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            long minChildHeight1 = SashPane.minChildHeight(this.c1, this.getWidth());
            long minChildHeight2 = SashPane.minChildHeight(this.c2, this.getWidth());
            if (newSize_1 < minChildHeight1) {
                newSize_2 = (long)this.resize_total - minChildHeight1;
                newSize_1 = minChildHeight1;
            }
            if (newSize_2 < minChildHeight2) {
                newSize_1 = (long)this.resize_total - minChildHeight2;
                newSize_2 = minChildHeight2;
            }
            if ((remainder = (long)this.resize_total - newSize_1 - newSize_2) != 0L) {
                newSize_1 += remainder;
            }
            if ((data1 = this.c1.getProperties().get((Object)LAYOUT_KEY)) == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            this.c1.resize((double)rectangle.width, (double)newSize_1);
            this.c2.resizeRelocate(this.c2.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1 + (double)this.getSashWidth(), (double)rectangle.width, (double)newSize_2);
            this.draggedSash.relocate(this.draggedSash.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1);
        }
    }

    private void handlePressedSash(MouseEvent e) {
        e.consume();
        Sash sash = (Sash)((Object)e.getSource());
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        this.start = this.horizontal.get() ? e.getScreenX() : e.getScreenY();
        this.draggedSash = sash;
        List<SashChild> visibleNodes = this.getManagedChildren().stream().filter(Node::isVisible).map(SashChild.class::cast).collect(Collectors.toList());
        if (this.hasFixedChild() && (((SashChild)((Object)visibleNodes.get(sashIndex))).isFixed() || ((SashChild)((Object)visibleNodes.get(sashIndex + 1))).isFixed())) {
            Bounds b;
            int idx;
            int n = idx = ((SashChild)((Object)visibleNodes.get(sashIndex))).isFixed() ? SashPane.findPrevUnfixed(visibleNodes, sashIndex) : sashIndex;
            if (idx != -1) {
                this.c1 = (Node)visibleNodes.get(idx);
                b = this.c1.getLayoutBounds();
                this.resize_1 = this.horizontal.get() ? b.getWidth() : b.getHeight();
            } else {
                this.c1 = null;
            }
            idx = SashPane.findNextUnfixed(visibleNodes, sashIndex);
            if (idx != -1) {
                this.c2 = (Node)visibleNodes.get(idx);
                b = this.c2.getLayoutBounds();
                this.resize_2 = this.horizontal.get() ? b.getWidth() : b.getHeight();
            } else {
                this.c2 = null;
            }
            this.resize_total = this.resize_1 + this.resize_2;
        } else {
            this.c1 = (Node)visibleNodes.get(sashIndex);
            Bounds b = this.c1.getLayoutBounds();
            this.resize_1 = this.horizontal.get() ? b.getWidth() : b.getHeight();
            this.c2 = (Node)visibleNodes.get(sashIndex + 1);
            b = this.c2.getLayoutBounds();
            this.resize_2 = this.horizontal.get() ? b.getWidth() : b.getHeight();
            this.resize_total = this.resize_1 + this.resize_2;
        }
    }

    private Sash createSash() {
        Sash sash = new Sash();
        sash.setOnMousePressed(this::handlePressedSash);
        sash.setOnMouseDragged(this::handleDragSash);
        sash.setOnMouseReleased(evt -> {
            this.draggedSash = null;
            this.c1 = null;
            this.c2 = null;
        });
        this.getChildren().add((Object)sash);
        return sash;
    }

    public void setWeights(int[] weights) {
        List children = this.getManagedChildren();
        if (weights == null || weights.length != children.size()) {
            throw new IllegalArgumentException();
        }
        int total = 0;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < 0) {
                throw new IllegalArgumentException();
            }
            total += weights[i];
            ++i;
        }
        if (total == 0) {
            throw new IllegalArgumentException();
        }
        i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            if (data == null || !(data instanceof SashFormData)) {
                data = new SashFormData();
                ((Node)children.get(i)).getProperties().put((Object)LAYOUT_KEY, data);
            }
            ((SashFormData)data).weight = (((long)weights[i] << 16) + (long)total - 1L) / (long)total;
            ++i;
        }
        this.clearCache();
        this.requestLayout();
    }

    public int[] getWeights() {
        List children = this.getManagedChildren();
        int[] ratios = new int[children.size()];
        int i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            ratios[i] = data != null && data instanceof SashFormData ? (int)(((SashFormData)data).weight * 1000L >> 16) : 200;
            ++i;
        }
        return ratios;
    }

    public ObjectProperty<int[]> weightsProperty() {
        if (this.weights == null) {
            this.weights = new SimpleObjectProperty((Object)this, "weights");
            this.weights.addListener((ob, ol, ne) -> {
                if (!this.syncInProgress) {
                    this.setWeights((int[])ne);
                }
            });
        }
        return this.weights;
    }

    public final BooleanProperty horizontalProperty() {
        return this.horizontal;
    }

    public final boolean isHorizontal() {
        return this.horizontalProperty().get();
    }

    public final void setHorizontal(boolean horizontal) {
        this.horizontalProperty().set(horizontal);
    }

    public final IntegerProperty sashWidthProperty() {
        return this.sashWidth;
    }

    public final int getSashWidth() {
        return this.sashWidthProperty().get();
    }

    public final void setSashWidth(int sashWidth) {
        this.sashWidthProperty().set(sashWidth);
    }

    public static interface FixedSashItem {
        public ObservableBooleanValue fixed();
    }

    static class Rectangle {
        int x;
        int y;
        int width;
        int height;

        public Rectangle(double width, double height, Insets insets) {
            this.x = (int)Math.ceil(insets.getLeft());
            this.y = (int)Math.ceil(insets.getTop());
            this.width = (int)Math.floor(width) - (int)Math.ceil(insets.getLeft()) - (int)Math.ceil(insets.getRight());
            this.height = (int)Math.floor(height) - (int)Math.ceil(insets.getTop()) - (int)Math.ceil(insets.getBottom());
        }

        public Rectangle(Bounds b) {
            this.x = (int)Math.ceil(b.getMinX());
            this.y = (int)Math.ceil(b.getMinY());
            this.width = (int)Math.floor(b.getWidth());
            this.height = (int)Math.floor(b.getHeight());
        }
    }

    static class Sash
    extends StackPane {
        public Sash() {
            this.getStyleClass().add((Object)"sash");
            this.setManaged(false);
            this.setMouseTransparent(false);
            Region r = new Region();
            r.getStyleClass().add((Object)"sash-handle");
            this.getChildren().add((Object)r);
        }
    }

    static class SashChild
    extends AnchorPane {
        ObjectProperty<Boolean> fixedSize = new SimpleObjectProperty();
        private javafx.scene.shape.Rectangle r = new javafx.scene.shape.Rectangle();

        public SashChild(Node c) {
            if (c instanceof FixedSashItem) {
                this.fixedSize.bind((ObservableValue)((FixedSashItem)c).fixed());
                this.fixedSize.addListener((ob, ol, ne) -> {
                    Parent parent = this.getParent();
                    if (parent != null) {
                        ((SashPane)parent).layoutChildren(true);
                    }
                });
            }
            this.getChildren().add((Object)c);
            this.setClip((Node)this.r);
            this.visibleProperty().bind((ObservableValue)c.visibleProperty());
            this.visibleProperty().addListener((ob, ol, ne) -> {
                Parent parent = this.getParent();
                if (parent != null) {
                    ((SashPane)parent).layoutChildren(true);
                }
            });
            AnchorPane.setBottomAnchor((Node)c, (Double)0.0);
            AnchorPane.setTopAnchor((Node)c, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)c, (Double)0.0);
            AnchorPane.setRightAnchor((Node)c, (Double)0.0);
        }

        public void resize(double width, double height) {
            super.resize(width, height);
            this.r.setWidth(width);
            this.r.setHeight(height);
        }

        public void dispose() {
            this.visibleProperty().unbind();
            this.fixedSize.unbind();
        }

        public boolean isFixed() {
            return Boolean.TRUE.equals(this.fixedSize.get());
        }
    }

    static class SashFormData {
        public long weight;

        SashFormData() {
        }
    }
}

