/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.model.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MatchRule implements Enumerator
{
    NONE(0, "none", "none"),
    EQUIVALENT(1, "equivalent", "equivalent"),
    COMPATIBLE(2, "compatible", "compatible"),
    PERFECT(3, "perfect", "perfect"),
    GREATER_OR_EQUAL(4, "greaterOrEqual", "greaterOrEqual");

    public static final int NONE_VALUE = 0;
    public static final int EQUIVALENT_VALUE = 1;
    public static final int COMPATIBLE_VALUE = 2;
    public static final int PERFECT_VALUE = 3;
    public static final int GREATER_OR_EQUAL_VALUE = 4;
    private static final MatchRule[] VALUES_ARRAY;
    public static final List<MatchRule> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MatchRule[]{NONE, EQUIVALENT, COMPATIBLE, PERFECT, GREATER_OR_EQUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MatchRule get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatchRule result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatchRule getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatchRule result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatchRule get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EQUIVALENT;
            }
            case 2: {
                return COMPATIBLE;
            }
            case 3: {
                return PERFECT;
            }
            case 4: {
                return GREATER_OR_EQUAL;
            }
        }
        return null;
    }

    private MatchRule(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

