/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.java7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fx.ide.jdt.core.internal.BuildPathSupport;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.IClasspathContributor;

public class JavaFXClassPathExtender
implements IClasspathContributor {
    private boolean onExtPath(IVMInstall i) {
        LibraryLocation[] libLocs = i.getLibraryLocations();
        if (libLocs == null) {
            libLocs = JavaRuntime.getLibraryLocations((IVMInstall)i);
        }
        if (libLocs != null) {
            LibraryLocation[] libraryLocationArray = libLocs;
            int n = libLocs.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryLocation l = libraryLocationArray[n2];
                if ("jfxrt.jar".equals(l.getSystemLibraryPath().lastSegment())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        String[] stringArray = project.getExecutionEnvironments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(e);
            if (env != null) {
                if (env.getDefaultVM() != null) {
                    if (this.onExtPath(env.getDefaultVM())) {
                        IClasspathEntry cp = this.getSWTEntry(env.getDefaultVM(), project);
                        if (cp != null) {
                            return Collections.singletonList(cp);
                        }
                        return Collections.emptyList();
                    }
                    IClasspathEntry cpe = this.getEntry(env.getDefaultVM(), project);
                    if (cpe != null) {
                        return Collections.singletonList(cpe);
                    }
                }
                IVMInstall[] iVMInstallArray = env.getCompatibleVMs();
                int n3 = iVMInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall vm = iVMInstallArray[n4];
                    if (env.isStrictlyCompatible(vm)) {
                        if (this.onExtPath(vm)) {
                            IClasspathEntry cp = this.getSWTEntry(vm, project);
                            if (cp != null) {
                                return Collections.singletonList(cp);
                            }
                            return Collections.emptyList();
                        }
                        IClasspathEntry cpe = this.getEntry(vm, project);
                        if (cpe != null) {
                            return Collections.singletonList(cpe);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    private IClasspathEntry getSWTEntry(IVMInstall vm, BundleDescription project) {
        IPath[] swtFxJarPath = BuildPathSupport.getSwtFxJarPath((IVMInstall)vm);
        if (swtFxJarPath != null) {
            ArrayList<IAccessRule> l = new ArrayList<IAccessRule>();
            l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf("javafx.embed.swt".replace('.', '/')) + "/*"), (int)0));
            IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)(swtFxJarPath[1] == null || !swtFxJarPath[1].toFile().exists() ? "http://docs.oracle.com/javafx/2/api/" : swtFxJarPath[1].toFile().toURI().toString()))};
            return JavaCore.newLibraryEntry((IPath)swtFxJarPath[0], (IPath)swtFxJarPath[2], null, (IAccessRule[])l.toArray(new IAccessRule[0]), (IClasspathAttribute[])extraAttributes, (boolean)false);
        }
        return null;
    }

    private IClasspathEntry getEntry(IVMInstall vm, BundleDescription project) {
        IPath[] paths = BuildPathSupport.getFxJarPath((IVMInstall)vm);
        if (paths == null) {
            return null;
        }
        ArrayList<IAccessRule> l = new ArrayList<IAccessRule>();
        ImportPackageSpecification[] importPackageSpecificationArray = project.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification i = importPackageSpecificationArray[n2];
            if (i.getName().startsWith("javafx")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)0));
            } else if (i.getName().startsWith("com.sun.browser")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.deploy")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.glass")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.javafx")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.media")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.openpisces")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.prism")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.scenario")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.t2k")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.webpane")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("netscape.javascript")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.javafx.scene.text")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            }
            ++n2;
        }
        IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)(paths[1] == null || !paths[1].toFile().exists() ? "http://docs.oracle.com/javafx/2/api/" : paths[1].toFile().toURI().toString()))};
        return JavaCore.newLibraryEntry((IPath)paths[0], null, null, (IAccessRule[])l.toArray(new IAccessRule[0]), (IClasspathAttribute[])extraAttributes, (boolean)false);
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

