/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.behavior.StyledTextBehavior;

public class StyledTextSkin
extends BehaviorSkinBase<StyledTextArea, StyledTextBehavior> {
    ListView<Line> contentView;
    StackPane lineRuler;
    ObservableList<Line> lineList = FXCollections.observableArrayList();
    Map<LineCell, LineInfo> lineInfoMap = new HashMap<LineCell, LineInfo>();
    HBox rootContainer = new HBox();

    public StyledTextSkin(StyledTextArea styledText) {
        super((Control)styledText, (BehaviorBase)new StyledTextBehavior(styledText));
        this.rootContainer.setSpacing(0.0);
        this.lineRuler = new LineRuler();
        this.lineRuler.visibleProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).lineRulerVisibleProperty());
        this.lineRuler.managedProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).lineRulerVisibleProperty());
        this.rootContainer.getChildren().add((Object)this.lineRuler);
        this.contentView = new ListView<Line>(){

            protected Skin<?> createDefaultSkin() {
                return new MyListViewSkin(this);
            }
        };
        this.contentView.getStyleClass().add((Object)"styled-text-area");
        this.contentView.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ((StyledTextArea)StyledTextSkin.this.getSkinnable()).requestFocus();
                }
            }
        });
        this.contentView.setCellFactory((Callback)new Callback<ListView<Line>, ListCell<Line>>(){

            public ListCell<Line> call(ListView<Line> arg0) {
                return new LineCell();
            }
        });
        this.contentView.setMinHeight(0.0);
        this.contentView.setMinWidth(0.0);
        this.contentView.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ((StyledTextBehavior)StyledTextSkin.this.getBehavior()).mousePressed(event, StyledTextSkin.this.getCurrentVisibleCells());
                event.consume();
            }
        });
        this.recalculateItems();
        this.contentView.setItems(this.lineList);
        HBox.setHgrow(this.contentView, (Priority)Priority.ALWAYS);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.contentView});
        this.getChildren().addAll((Object[])new Node[]{this.rootContainer});
        styledText.caretOffsetProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int lineIndex = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLineAtOffset(newValue.intValue());
                Line lineObject = (Line)StyledTextSkin.this.lineList.get(lineIndex);
                StyledTextSkin.this.getFlow().show(lineIndex);
                for (LineCell c : StyledTextSkin.this.getCurrentVisibleCells()) {
                    if (c.domainElement != lineObject) continue;
                    if (StyledTextSkin.this.contentView.getSelectionModel().getSelectedItem() != c.domainElement) {
                        StyledTextSkin.this.contentView.getSelectionModel().select((Object)lineObject);
                    }
                    RegionImpl container = (RegionImpl)c.getGraphic();
                    TextFlow flow = (TextFlow)container.getChildren().get(0);
                    flow.requestLayout();
                    return;
                }
            }
        });
        styledText.selectionProperty().addListener((ChangeListener)new ChangeListener<TextSelection>(){

            public void changed(ObservableValue<? extends TextSelection> observable, TextSelection oldValue, TextSelection newValue) {
                StyledTextSkin.this.recalculateItems();
            }
        });
    }

    MyVirtualFlow getFlow() {
        if (this.contentView == null || this.contentView.getSkin() == null) {
            return null;
        }
        return ((MyListViewSkin)this.contentView.getSkin()).getFlow();
    }

    public double getLineHeight(int caretPosition) {
        int lineIndex = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(caretPosition);
        Line lineObject = (Line)this.lineList.get(lineIndex);
        for (LineCell c : this.getCurrentVisibleCells()) {
            if (c.domainElement != lineObject) continue;
            return c.getHeight();
        }
        return 0.0;
    }

    public Point2D getCaretLocation(int caretPosition) {
        if (caretPosition < 0) {
            return null;
        }
        int lineIndex = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(caretPosition);
        Line lineObject = (Line)this.lineList.get(lineIndex);
        for (LineCell c : this.getCurrentVisibleCells()) {
            if (c.domainElement != lineObject) continue;
            RegionImpl container = (RegionImpl)c.getGraphic();
            TextFlow flow = (TextFlow)container.getChildren().get(0);
            Text textNode = null;
            int relativePos = 0;
            int i = flow.getChildren().size() - 1;
            while (i >= 0) {
                Node n = (Node)flow.getChildren().get(i);
                int offset = (Integer)n.getUserData();
                if (offset <= caretPosition) {
                    relativePos = caretPosition - offset;
                    textNode = (Text)n;
                    break;
                }
                --i;
            }
            if (textNode == null) continue;
            textNode.setImpl_caretPosition(relativePos);
            PathElement[] elements = textNode.getImpl_caretShape();
            double xShift = textNode.getLayoutX();
            PathElement[] pathElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                PathElement e = pathElementArray[n2];
                if (e instanceof MoveTo) {
                    xShift += ((MoveTo)e).getX();
                }
                ++n2;
            }
            Point2D rv = new Point2D(xShift, c.getLayoutY());
            return rv;
        }
        return null;
    }

    protected double computeMinHeight(double width) {
        return this.contentView.minHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.contentView.minWidth(height);
    }

    public void recalculateItems() {
        if (this.lineList.size() != ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
            if (this.lineList.size() > ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
                this.lineList.remove(((StyledTextArea)this.getSkinnable()).getContent().getLineCount(), this.lineList.size());
            } else {
                ArrayList<Line> tmp = new ArrayList<Line>(((StyledTextArea)this.getSkinnable()).getContent().getLineCount() - this.lineList.size());
                int i = this.lineList.size();
                while (i < ((StyledTextArea)this.getSkinnable()).getContent().getLineCount()) {
                    tmp.add(new Line());
                    ++i;
                }
                this.lineList.addAll(tmp);
            }
        }
        this.redraw();
    }

    public void redraw() {
        for (LineCell l : this.getCurrentVisibleCells()) {
            if (l == null) continue;
            l.update();
        }
    }

    List<LineCell> getCurrentVisibleCells() {
        if (this.contentView == null || this.contentView.getSkin() == null) {
            return Collections.emptyList();
        }
        return ((MyListViewSkin)this.contentView.getSkin()).getFlow().getCells();
    }

    static String removeLineending(String s) {
        return s.replace("\n", "").replace("\r", "");
    }

    public class Line {
        public String getText() {
            return StyledTextSkin.removeLineending(((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(StyledTextSkin.this.lineList.indexOf((Object)this)));
        }

        public int getLineOffset() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            return ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getOffsetAtLine(idx);
        }

        public int getLineLength() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            String s = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(idx);
            return s.length();
        }

        public List<Segment> getSegments() {
            int idx = StyledTextSkin.this.lineList.indexOf((Object)this);
            ArrayList<Segment> segments = new ArrayList<Segment>();
            String line = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLine(idx);
            if (line != null) {
                int start = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getOffsetAtLine(idx);
                int length = line.length();
                StyleRange[] ranges = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getStyleRanges(start, length, true);
                if (ranges == null) {
                    return Collections.emptyList();
                }
                TextSelection selection = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getSelection();
                int selectionStart = selection.offset - start;
                int selectionEnd = selection.offset + selection.length - start;
                int lastIndex = -1;
                StyleRange[] styleRangeArray = ranges;
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange r = styleRangeArray[n2];
                    int begin = r.start - start;
                    int end = r.start - start + r.length;
                    if (lastIndex != -1 && lastIndex != begin) {
                        segments.addAll(this.createSegments(line, new StyleRange(null), selectionStart, selectionEnd, lastIndex, begin));
                    }
                    segments.addAll(this.createSegments(line, r, selectionStart, selectionEnd, begin, end));
                    lastIndex = end;
                    ++n2;
                }
            }
            return segments;
        }

        private List<Segment> createSegments(String line, StyleRange r, int selectionStart, int selectionEnd, int begin, int end) {
            if (selectionStart != selectionEnd) {
                if (selectionStart <= begin && selectionEnd >= end) {
                    Segment seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(begin, end));
                    seg.style = new StyleRange(r);
                    seg.style.hoverStylename = "hover";
                    return Collections.singletonList(seg);
                }
                if (selectionStart <= begin && selectionEnd >= begin && selectionEnd <= end) {
                    ArrayList<Segment> rv = new ArrayList<Segment>();
                    Segment seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(begin, selectionEnd));
                    seg.style = new StyleRange(r);
                    seg.style.hoverStylename = "hover";
                    seg.style.start = r.start;
                    rv.add(seg);
                    seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(selectionEnd, end));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start + selectionEnd - begin;
                    rv.add(seg);
                    return rv;
                }
                if (begin < selectionStart && selectionStart <= end && selectionEnd >= end) {
                    ArrayList<Segment> rv = new ArrayList<Segment>();
                    Segment seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(begin, selectionStart));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start;
                    rv.add(seg);
                    seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(selectionStart, end));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start + selectionStart - begin;
                    seg.style.hoverStylename = "hover";
                    rv.add(seg);
                    return rv;
                }
                if (this.between(selectionStart, begin, end) && this.between(selectionEnd, begin, end)) {
                    ArrayList<Segment> rv = new ArrayList<Segment>();
                    Segment seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(begin, selectionStart));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start;
                    rv.add(seg);
                    seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(selectionStart, selectionEnd));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start + selectionStart - begin;
                    seg.style.hoverStylename = "hover";
                    rv.add(seg);
                    seg = new Segment();
                    seg.text = StyledTextSkin.removeLineending(line.substring(selectionEnd, end));
                    seg.style = new StyleRange(r);
                    seg.style.start = r.start + selectionEnd - begin;
                    rv.add(seg);
                    return rv;
                }
            }
            Segment seg = new Segment();
            seg.text = StyledTextSkin.removeLineending(line.substring(begin, end));
            seg.style = r;
            return Collections.singletonList(seg);
        }

        private boolean between(int x, int min, int max) {
            return x > min && x < max;
        }
    }

    public class LineCell
    extends ListCell<Line> {
        Line domainElement;
        private BooleanBinding caretVisible;
        BooleanProperty flashProperty;
        Timeline flashTimeline;

        public LineCell() {
            this.getStyleClass().add((Object)"styled-text-line");
            this.flashProperty = new SimpleBooleanProperty((Object)this, "flash", false);
            this.flashTimeline = new Timeline();
            this.flashTimeline.setCycleCount(-1);
            EventHandler<ActionEvent> startEvent = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    LineCell.this.flashProperty.set(true);
                }
            };
            EventHandler<ActionEvent> endEvent = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    LineCell.this.flashProperty.set(false);
                }
            };
            this.flashTimeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, (EventHandler)startEvent, new KeyValue[0]), new KeyFrame(Duration.millis((double)500.0), (EventHandler)endEvent, new KeyValue[0]), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[0])});
            this.caretVisible = new BooleanBinding(){
                {
                    this.bind(new Observable[]{LineCell.this.selectedProperty(), LineCell.this.flashProperty});
                }

                protected boolean computeValue() {
                    return LineCell.this.selectedProperty().get() && LineCell.this.flashProperty.get();
                }
            };
            this.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (arg2.booleanValue()) {
                        LineCell.this.flashTimeline.play();
                    } else {
                        LineCell.this.flashTimeline.stop();
                    }
                }
            });
        }

        public Line getDomainElement() {
            return this.domainElement;
        }

        public void update() {
            if (this.domainElement != null) {
                this.updateItem(this.domainElement, false);
            }
        }

        public void updateCaret() {
            int caretPosition = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getCaretOffset();
            if (caretPosition < 0) {
                return;
            }
            int lineIndex = ((StyledTextArea)StyledTextSkin.this.getSkinnable()).getContent().getLineAtOffset(caretPosition);
            Line lineObject = (Line)StyledTextSkin.this.lineList.get(lineIndex);
            for (LineCell c : StyledTextSkin.this.getCurrentVisibleCells()) {
                if (c.domainElement != lineObject) continue;
                RegionImpl container = (RegionImpl)c.getGraphic();
                TextFlow flow = (TextFlow)container.getChildren().get(0);
                TextFlow textNode = null;
                int relativePos = 0;
                int i = flow.getChildren().size() - 1;
                while (i >= 0) {
                    Node n = (Node)flow.getChildren().get(i);
                    int offset = (Integer)n.getUserData();
                    if (offset <= caretPosition) {
                        relativePos = caretPosition - offset;
                        textNode = (TextFlow)n;
                        break;
                    }
                    --i;
                }
                if (textNode == null) break;
                ((Text)textNode.getChildren().get(0)).setImpl_caretPosition(relativePos);
                Path p = (Path)container.getChildren().get(1);
                p.getElements().clear();
                p.getElements().addAll((Object[])((Text)textNode.getChildren().get(0)).getImpl_caretShape());
                p.setLayoutX(((Node)textNode.getChildren().get(0)).getLayoutX() + textNode.getLayoutX());
                p.setLayoutY(((Node)textNode.getChildren().get(0)).getLayoutY() + textNode.getLayoutY());
                break;
            }
        }

        protected void updateItem(Line arg0, boolean arg1) {
            if (!arg1) {
                TextFlow flow;
                this.domainElement = arg0;
                LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)this);
                if (lineInfo == null) {
                    lineInfo = new LineInfo();
                    lineInfo.setDomainElement(this.domainElement);
                    StyledTextSkin.this.lineInfoMap.put(this, lineInfo);
                    StyledTextSkin.this.lineRuler.getChildren().add((Object)lineInfo);
                    StyledTextSkin.this.lineRuler.requestLayout();
                } else {
                    lineInfo.setDomainElement(this.domainElement);
                    StyledTextSkin.this.lineRuler.requestLayout();
                }
                lineInfo.setLayoutY(this.getLayoutY());
                RegionImpl stack = (RegionImpl)this.getGraphic();
                if (stack == null) {
                    flow = new TextFlow(){

                        protected void layoutChildren() {
                            super.layoutChildren();
                            LineCell.this.updateCaret();
                        }
                    };
                    Path caretPath = new Path();
                    caretPath.getStyleClass().add((Object)"text-caret");
                    caretPath.setManaged(false);
                    caretPath.setStrokeWidth(2.0);
                    caretPath.visibleProperty().bind((ObservableValue)this.caretVisible);
                    stack = new RegionImpl(new Node[]{flow, caretPath});
                    this.setGraphic((Node)stack);
                } else {
                    flow = (TextFlow)stack.getChildren().get(0);
                }
                ArrayList<TextFlow> texts = new ArrayList<TextFlow>();
                if (arg0.getSegments().isEmpty()) {
                    this.setPrefHeight(20.0);
                } else {
                    this.setPrefHeight(-1.0);
                }
                for (Segment seg : arg0.getSegments()) {
                    Text t = new Text(seg.text);
                    if (seg.style.stylename != null) {
                        t.getStyleClass().setAll((Object[])new String[]{"source-segment", seg.style.stylename});
                    } else if (seg.style.foreground != null) {
                        t.getStyleClass().setAll((Object[])new String[]{"plain-source-segment"});
                    } else {
                        t.getStyleClass().setAll((Object[])new String[]{"source-segment"});
                    }
                    if (seg.style.foreground != null) {
                        t.setFill((Paint)seg.style.foreground);
                    }
                    if (seg.style.font != null) {
                        t.setFont(seg.style.font);
                    }
                    boolean cfr_ignored_0 = seg.style.underline;
                    TextFlow f = new TextFlow(new Node[]{t});
                    f.setUserData((Object)seg.style.start);
                    if (seg.style.hoverStylename != null) {
                        f.getStyleClass().setAll((Object[])new String[]{"source-segment-container", seg.style.hoverStylename});
                        texts.add(f);
                        continue;
                    }
                    f.getStyleClass().setAll((Object[])new String[]{"source-segment-container"});
                    texts.add(f);
                }
                if (texts.isEmpty()) {
                    Text t = new Text("");
                    t.getStyleClass().setAll((Object[])new String[]{"source-segment"});
                    TextFlow f = new TextFlow(new Node[]{t});
                    f.setUserData((Object)arg0.getLineOffset());
                    texts.add(f);
                }
                flow.getChildren().setAll(texts);
            } else {
                this.setGraphic(null);
                this.domainElement = null;
                LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.remove((Object)this);
                if (lineInfo != null) {
                    lineInfo.setDomainElement(null);
                    StyledTextSkin.this.lineRuler.getChildren().remove((Object)lineInfo);
                }
            }
            super.updateItem((Object)arg0, arg1);
        }
    }

    class LineInfo
    extends HBox {
        private Label markerLabel = new Label();
        private Label lineText;
        private Line line;

        public LineInfo() {
            this.markerLabel.setPrefWidth(20.0);
            this.lineText = new Label();
            this.lineText.getStyleClass().add((Object)"line-ruler-text");
            this.lineText.setMaxWidth(Double.MAX_VALUE);
            this.lineText.setMaxHeight(Double.MAX_VALUE);
            this.lineText.setAlignment(Pos.CENTER_RIGHT);
            HBox.setHgrow((Node)this.lineText, (Priority)Priority.ALWAYS);
            this.getChildren().addAll((Object[])new Node[]{this.markerLabel, this.lineText});
        }

        public void setDomainElement(Line line) {
            if (line == null) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                if (line != this.line) {
                    this.line = line;
                    String newText = String.valueOf(StyledTextSkin.this.lineList.indexOf((Object)line) + 1);
                    String oldText = this.lineText.getText();
                    if (oldText == null) {
                        oldText = "";
                    }
                    this.lineText.setText(newText);
                    if (newText.length() != oldText.length()) {
                        StyledTextSkin.this.rootContainer.layout();
                    }
                    StyledTextSkin.this.lineRuler.layout();
                }
            }
        }
    }

    class LineRuler
    extends StackPane {
        LineRuler() {
        }

        protected void layoutChildren() {
            super.layoutChildren();
            HashSet children = new HashSet(this.getChildren());
            ArrayList<LineInfo> layouted = new ArrayList<LineInfo>();
            double maxWidth = 0.0;
            for (LineCell c : ((MyListViewSkin)StyledTextSkin.this.contentView.getSkin()).getFlow().getCells()) {
                LineInfo lineInfo;
                if (!c.isVisible() || (lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)c)) == null) continue;
                layouted.add(lineInfo);
                maxWidth = Math.max(maxWidth, lineInfo.getWidth());
                lineInfo.relocate(0.0, c.getLayoutY());
                lineInfo.resize(lineInfo.getWidth(), c.getHeight());
                lineInfo.setVisible(true);
                children.remove((Object)lineInfo);
            }
            for (LineInfo l : layouted) {
                l.resize(maxWidth, l.getHeight());
            }
            for (Node n : children) {
                n.setVisible(false);
            }
        }
    }

    class MyListViewSkin
    extends ListViewSkin<Line> {
        private MyVirtualFlow flow;

        public MyListViewSkin(ListView<Line> listView) {
            super(listView);
        }

        public MyVirtualFlow getFlow() {
            return this.flow;
        }

        protected VirtualFlow<ListCell<Line>> createVirtualFlow() {
            this.flow = new MyVirtualFlow();
            return this.flow;
        }
    }

    class MyVirtualFlow
    extends VirtualFlow<LineCell> {
        MyVirtualFlow() {
        }

        protected void positionCell(LineCell cell, double position) {
            super.positionCell((IndexedCell)cell, position);
            LineInfo lineInfo = StyledTextSkin.this.lineInfoMap.get((Object)cell);
            if (lineInfo != null) {
                lineInfo.setDomainElement(cell.domainElement);
                lineInfo.setLayoutY(cell.getLayoutY());
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((MyVirtualFlow)MyVirtualFlow.this).StyledTextSkin.this.lineRuler.requestLayout();
                }
            });
        }

        public List<LineCell> getCells() {
            return super.getCells();
        }
    }

    static class RegionImpl
    extends Region {
        public RegionImpl(Node ... nodes) {
            this.getChildren().addAll((Object[])nodes);
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }
    }

    class Segment {
        public String text;
        public StyleRange style;

        Segment() {
        }

        public String toString() {
            return String.valueOf(this.text) + " => " + this.style;
        }
    }
}

