/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.ide.jdt.ui.internal.editors.AddDialog;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.KeyValuePair;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersFactory;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersPackage;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class AddMetaInfFileDialog
extends AddDialog<KeyValuePair> {
    private KeyValuePair o;
    private Text tFolder;
    private Text tFile;
    private final EditingDomain editingDomain;
    private final AntTask task;
    private final IContainer resourceContainer;

    public AddMetaInfFileDialog(Shell parentShell, EditingDomain editingDomain, AntTask task, IContainer resourceContainer) {
        super(parentShell);
        this.editingDomain = editingDomain;
        this.task = task;
        this.resourceContainer = resourceContainer;
    }

    @Override
    protected Control createDialogContent(Composite parent) {
        this.o = ParametersFactory.eINSTANCE.createKeyValuePair();
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(1808));
        this.getShell().setText("Add META-INF file");
        this.setTitle("Add META-INF file");
        this.setMessage("Enter informations about the META-INF file to add");
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(1808));
        IWidgetValueProperty tProp = WidgetProperties.text((int)24);
        Label l = new Label(container, 0);
        l.setText("Service Folder*:");
        this.tFolder = new Text(container, 2048);
        this.tFolder.setLayoutData((Object)new GridData(768));
        GridData tFolderGD = new GridData(768);
        tFolderGD.horizontalSpan = 3;
        this.tFolder.setLayoutData((Object)tFolderGD);
        IEMFEditValueProperty prop = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__KEY);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tFolder), prop.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        l = new Label(container, 0);
        l.setText("File*:");
        this.tFile = new Text(container, 2048);
        this.tFile.setLayoutData((Object)new GridData(768));
        this.tFile.setEditable(false);
        IEMFEditValueProperty prop2 = EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ParametersPackage.Literals.KEY_VALUE_PAIR__VALUE);
        this.dbContext.bindValue((IObservableValue)tProp.observeDelayed(500, (Widget)this.tFile), prop2.observe((Object)this.o), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy());
        Button bFilesystem = new Button(container, 0);
        bFilesystem.setText("Filesystem ...");
        bFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog d = new FileDialog(AddMetaInfFileDialog.this.getShell());
                String val = d.open();
                if (val != null) {
                    AddMetaInfFileDialog.this.tFile.setText(val);
                }
            }
        });
        Button bWorkspace = new Button(container, 0);
        bWorkspace.setText("Workspace ...");
        bWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] rv;
                FilteredResourcesSelectionDialog d = new FilteredResourcesSelectionDialog(AddMetaInfFileDialog.this.getShell(), false, AddMetaInfFileDialog.this.resourceContainer, 1){

                    protected IStatus validateItem(Object item) {
                        IFile f = (IFile)item;
                        if (f.getParent() instanceof IProject) {
                            return new Status(4, "org.eclipse.fx.ide.jdt.ui", "The selected resource has to be part of the source folder");
                        }
                        return super.validateItem(item);
                    }
                };
                if (d.open() == 0 && (rv = d.getResult()).length == 1) {
                    IFile f = (IFile)rv[0];
                    AddMetaInfFileDialog.this.tFile.setText("${workspace}/" + f.getProject().getName() + "/" + f.getProjectRelativePath().toString());
                }
            }
        });
        return area;
    }

    @Override
    protected Command generateOkCommand() {
        return new AddCommand(this.editingDomain, this.task.getFiles(), (Object)this.o);
    }

    @Override
    protected IStatus validate() {
        Status status = this.tFolder.getText() == null || this.tFolder.getText().trim().equals("") ? new Status(4, "org.eclipse.fx.ide.jdt.ui", "Please enter a folder") : (this.tFile.getText() == null || this.tFile.getText().trim().equals("") ? new Status(4, "org.eclipse.fx.ide.jdt.ui", "Please enter a file") : new Status(0, "org.eclipse.fx.ide.jdt.ui", "OK"));
        return status;
    }

    @Override
    protected KeyValuePair getObject() {
        return this.o;
    }
}

