/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.core.op.StashApplyOperation;
import org.eclipse.egit.core.op.StashCreateOperation;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

class AutoRebaseProcess
extends Job {
    private Repository localRepo;
    private RevisionInfo revisionInfo;
    private GerritClient gerritClient;
    private String dateNowBranchFormat;
    private String branchBeforeAutoRebase = "";
    private RevCommit stashRefCommit = null;
    private String tempName;
    private ChangeInfo baseChange;
    private final String DOUBLE_LINE_FEED = "\r\r";

    AutoRebaseProcess(GerritClient gerritClient, Repository localRepo, RevisionInfo revisionInfo, ChangeInfo baseChange) {
        super(Messages.AutoRebaseProcess_AutomaticallyRebasing);
        this.gerritClient = gerritClient;
        this.localRepo = localRepo;
        this.revisionInfo = revisionInfo;
        this.baseChange = baseChange;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy/MM/dd.HH-mm-ss");
        Date date = new Date();
        this.dateNowBranchFormat = dateFormat.format(date);
    }

    protected IStatus run(IProgressMonitor monitor) {
        AutoRebaseStep lastSuccessfulStep = AutoRebaseStep.NONE;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        if (!this.isRebaseable().booleanValue()) {
            RepositoryState currentState = this.localRepo.getRepositoryState();
            if (currentState == RepositoryState.REBASING || currentState == RepositoryState.REBASING_MERGE || currentState == RepositoryState.REBASING_INTERACTIVE) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.AutoRebaseProcess_RebaseCancelled, (String)(String.valueOf(Messages.AutoRebaseProcess_FailedRepoFollowingState) + AutoRebaseProcess.this.localRepo.getRepositoryState().getDescription() + "\r\r" + Messages.AutoRebaseProcess_PleaseFinishOrCancelCurrentRebase));
                        try {
                            AutoRebaseProcess.this.openStagingView();
                        }
                        catch (PartInitException e) {
                            EGerritCorePlugin.logError((String)e.getMessage());
                        }
                    }
                });
                return Status.OK_STATUS;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.AutoRebaseProcess_RebaseCancelled, (String)(String.valueOf(Messages.AutoRebaseProcess_FailedRepoFollowingState) + AutoRebaseProcess.this.localRepo.getRepositoryState().getDescription() + "\r\r"));
                }
            });
            return Status.OK_STATUS;
        }
        try {
            this.branchBeforeAutoRebase = this.localRepo.getBranch();
        }
        catch (IOException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return Status.OK_STATUS;
        }
        RevCommit commit = this.fetchRemoteChange(subMonitor);
        if (commit == null) {
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.FETCH_PATCHSET;
        this.tempName = "automatic-rebase-" + this.revisionInfo.getRef().toString().substring(13) + "-" + this.dateNowBranchFormat;
        if (!this.stashCurrentChanges(subMonitor)) {
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.STASH_CHANGES;
        if (!this.createLocalBranch(subMonitor, commit)) {
            try {
                this.handleFailure(lastSuccessfulStep, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.CREATE_BRANCH;
        if (!this.checkoutCreatedBranch(subMonitor)) {
            try {
                this.handleFailure(lastSuccessfulStep, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.CHECKOUT_BRANCH;
        if (!this.fetchRemoteBranch(subMonitor)) {
            try {
                this.handleFailure(lastSuccessfulStep, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.FETCH_BRANCH;
        if (!this.rebaseLocally(subMonitor)) {
            try {
                this.handleFailure(lastSuccessfulStep, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
            return Status.OK_STATUS;
        }
        lastSuccessfulStep = AutoRebaseStep.REBASE_INIT;
        return Status.OK_STATUS;
    }

    private void handleFailure(AutoRebaseStep lastSuccessfulStep, IProgressMonitor monitor) throws CoreException, IOException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException, GitAPIException {
        monitor.setTaskName(Messages.AutoRebaseProcess_RevertingSteps);
        switch (lastSuccessfulStep) {
            case STASH_CHANGES: {
                if (this.stashRefCommit == null) break;
                StashApplyOperation stashApplyOp = new StashApplyOperation(this.localRepo, this.stashRefCommit);
                stashApplyOp.execute(monitor);
                break;
            }
            case CREATE_BRANCH: {
                Ref branch = null;
                branch = this.localRepo.findRef(this.tempName);
                DeleteBranchOperation delBranchOp = new DeleteBranchOperation(this.localRepo, branch, true);
                delBranchOp.execute(monitor);
                if (this.stashRefCommit == null) break;
                StashApplyOperation stashApplyOp = new StashApplyOperation(this.localRepo, this.stashRefCommit);
                stashApplyOp.execute(monitor);
                break;
            }
            case CHECKOUT_BRANCH: 
            case FETCH_BRANCH: {
                CheckoutCommand co = null;
                Git git = new Git(this.localRepo);
                co = git.checkout();
                co.setName(this.branchBeforeAutoRebase);
                co.call();
                git.close();
                Ref branch = null;
                branch = this.localRepo.findRef(this.tempName);
                DeleteBranchOperation delBranchOp = new DeleteBranchOperation(this.localRepo, branch, true);
                delBranchOp.execute(monitor);
                if (this.stashRefCommit == null) break;
                StashApplyOperation stashApplyOp = new StashApplyOperation(this.localRepo, this.stashRefCommit);
                stashApplyOp.execute(monitor);
                break;
            }
            case REBASE_INIT: {
                RebaseOperation abortOp = new RebaseOperation(this.localRepo, RebaseCommand.Operation.ABORT);
                abortOp.execute(monitor);
                CheckoutCommand co = null;
                Git git = new Git(this.localRepo);
                co = git.checkout();
                co.setName(this.branchBeforeAutoRebase);
                co.call();
                git.close();
                Ref branch = null;
                branch = this.localRepo.findRef(this.tempName);
                DeleteBranchOperation delBranchOp = new DeleteBranchOperation(this.localRepo, branch, true);
                delBranchOp.execute(monitor);
                if (this.stashRefCommit == null) break;
                StashApplyOperation stashApplyOp = new StashApplyOperation(this.localRepo, this.stashRefCommit);
                stashApplyOp.execute(monitor);
            }
        }
        monitor.done();
    }

    private boolean rebaseLocally(SubMonitor subMonitor) {
        subMonitor.setTaskName(Messages.AutoRebaseProcess_RebasingLocally);
        RebaseResult rebaseResult = null;
        try {
            rebaseResult = this.rebase((IProgressMonitor)subMonitor);
        }
        catch (IOException | CoreException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return false;
        }
        subMonitor.worked(1);
        CustomRebaseStatusDialog customRebaseStatus = new CustomRebaseStatusDialog(rebaseResult);
        Display.getDefault().syncExec((Runnable)customRebaseStatus);
        return customRebaseStatus.isSuccess();
    }

    private boolean checkoutCreatedBranch(SubMonitor subMonitor) {
        subMonitor.setTaskName(Messages.AutoRebaseProcess_CheckoutNewlyCreatedLocalBranch);
        CheckoutCommand co = null;
        Git git = new Git(this.localRepo);
        co = git.checkout();
        co.setName(this.tempName);
        try {
            co.call();
        }
        catch (GitAPIException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            git.close();
            return false;
        }
        if (co.getResult().getStatus() != CheckoutResult.Status.OK) {
            git.close();
            return false;
        }
        subMonitor.worked(1);
        git.close();
        return true;
    }

    private boolean createLocalBranch(SubMonitor subMonitor, RevCommit commit) {
        subMonitor.setTaskName(Messages.AutoRebaseProcess_CreatingNewLocalBranch);
        CreateLocalBranchOperation bop = new CreateLocalBranchOperation(this.localRepo, this.tempName, commit);
        try {
            bop.execute((IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean stashCurrentChanges(SubMonitor subMonitor) {
        subMonitor.setTaskName(Messages.AutoRebaseProcess_StashingCurrentChanges);
        try {
            this.stashRefCommit = this.stashChanges((IProgressMonitor)subMonitor, this.tempName);
        }
        catch (TeamException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)2, null, (String)Messages.AutoRebaseProcess_AutoRebaseFailed, (String)Messages.AutoRebaseProcess_AutoRebaseCouldNotStartFixRepo, (int)0);
                }
            });
            return false;
        }
        catch (CoreException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return false;
        }
        subMonitor.worked(1);
        return true;
    }

    private RevCommit fetchRemoteChange(SubMonitor subMonitor) {
        FetchResult fetchRes;
        block18: {
            subMonitor.setTaskName(Messages.AutoRebaseProcess_FetchingRemotePatchSet);
            ArrayList<RefSpec> patchSpecs = new ArrayList<RefSpec>(1);
            try {
                patchSpecs.add(this.getSourceRefSpec());
            }
            catch (IOException e1) {
                EGerritCorePlugin.logError((String)e1.getMessage());
            }
            fetchRes = null;
            try {
                URIish uri = this.getRemoteURI();
                if (uri != null) {
                    fetchRes = new FetchOperationUI(this.localRepo, uri, patchSpecs, 0, false).execute((IProgressMonitor)subMonitor);
                    break block18;
                }
                return null;
            }
            catch (CoreException e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
        }
        if (fetchRes == null) {
            return null;
        }
        RevCommit commit = null;
        Throwable throwable = null;
        Object var6_9 = null;
        try (RevWalk rw = new RevWalk(this.localRepo);){
            try {
                commit = rw.parseCommit((AnyObjectId)fetchRes.getAdvertisedRef(this.getSourceRefSpec().getSource()).getObjectId());
            }
            catch (IOException e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (commit == null) {
            return null;
        }
        subMonitor.worked(1);
        return commit;
    }

    private boolean fetchRemoteBranch(SubMonitor subMonitor) {
        FetchResult fetchResBranch;
        block3: {
            subMonitor.setTaskName(Messages.AutoRebaseProcess_FetchingRemoteBranch);
            ArrayList<RefSpec> branchSpecs = new ArrayList<RefSpec>(1);
            RefSpec refSpecBranch = this.baseChange == null ? new RefSpec().setSource("refs/heads/" + this.revisionInfo.getChangeInfo().getBranch()).setDestination("FETCH_HEAD") : new RefSpec().setSource(this.baseChange.getRevision().getRef()).setDestination("FETCH_HEAD");
            branchSpecs.add(refSpecBranch);
            fetchResBranch = null;
            try {
                URIish uri = this.getRemoteURI();
                if (uri != null) {
                    fetchResBranch = new FetchOperationUI(this.localRepo, uri, branchSpecs, 0, false).execute((IProgressMonitor)subMonitor);
                    break block3;
                }
                return false;
            }
            catch (CoreException e) {
                EGerritCorePlugin.logError((String)e.getMessage());
            }
        }
        return fetchResBranch != null;
    }

    private Boolean isRebaseable() {
        return this.localRepo.getRepositoryState().canCheckout();
    }

    private RebaseResult rebase(IProgressMonitor monitor) throws CoreException, IOException {
        RebaseOperation operation = new RebaseOperation(this.localRepo, this.getSourceRef(), null);
        operation.execute(monitor);
        return operation.getResult();
    }

    private RevCommit stashChanges(IProgressMonitor monitor, String name) throws CoreException {
        StashCreateOperation op = new StashCreateOperation(this.localRepo, name);
        op.execute(monitor);
        return op.getCommit();
    }

    private Ref getSourceRef() throws IOException {
        return this.localRepo.findRef("FETCH_HEAD");
    }

    private URIish getRemoteURI() {
        try {
            return new URIish(String.valueOf(this.gerritClient.getRepository().getURIBuilder(false).toString()) + "/" + this.revisionInfo.getChangeInfo().getProject());
        }
        catch (URISyntaxException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return null;
        }
    }

    private RefSpec getSourceRefSpec() throws IOException {
        return new RefSpec().setSource(this.revisionInfo.getRef()).setDestination("FETCH_HEAD");
    }

    private void openStagingView() throws PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.StagingView");
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.egit.ui.StagingView");
        if (part instanceof StagingView) {
            StagingView view = (StagingView)part;
            view.reload(this.localRepo);
        }
    }

    private static enum AutoRebaseStep {
        NONE,
        FETCH_PATCHSET,
        STASH_CHANGES,
        CREATE_BRANCH,
        CHECKOUT_BRANCH,
        FETCH_BRANCH,
        REBASE_INIT;

    }

    private class CustomRebaseStatusDialog
    implements Runnable {
        private RebaseResult status;
        private boolean success = false;

        public CustomRebaseStatusDialog(RebaseResult rebaseResult) {
            this.status = rebaseResult;
        }

        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public void run() {
            String dialogMessage = "";
            if (this.status.getStatus() == RebaseResult.Status.STOPPED || this.status.getStatus() == RebaseResult.Status.FAST_FORWARD || this.status.getStatus() == RebaseResult.Status.OK) {
                try {
                    String stashMessage = Messages.AutoRebaseProcess_StashingTheLocalChanges;
                    if (AutoRebaseProcess.this.stashRefCommit != null) {
                        stashMessage = String.valueOf(Messages.AutoRebaseProcess_StashingLocalChanges) + AutoRebaseProcess.this.tempName;
                    }
                    dialogMessage = String.valueOf(Messages.AutoRebaseProcess_FollowingStepsSuccessful) + " :\r\r" + "-" + stashMessage + "\r" + "-" + Messages.AutoRebaseProcess_CheckingOutBranchToRebase + " : " + AutoRebaseProcess.this.tempName + "\r" + "-" + Messages.AutoRebaseProcess_FetchingTheBranches + "\r" + "-" + Messages.AutoRebaseProcess_StartingTheRebaseProcess + "\r\r" + Messages.AutoRebaseProcess_currentRebaseStatus;
                    String rebaseMessage = "";
                    switch (this.status.getStatus()) {
                        case STOPPED: {
                            rebaseMessage = Messages.AutoRebaseProcess_StoppedConflict;
                            break;
                        }
                        case OK: {
                            rebaseMessage = Messages.AutoRebaseProcess_RebaseSuccessful;
                            break;
                        }
                        case FAST_FORWARD: {
                            rebaseMessage = Messages.AutoRebaseProcess_RebaseFF;
                        }
                    }
                    dialogMessage = String.valueOf(dialogMessage) + rebaseMessage + "\r\r" + Messages.AutoRebaseProcess_CommitAndPushChanges;
                    MessageDialog.open((int)2, null, (String)Messages.AutoRebaseProcess_AutoRebaseStarted, (String)dialogMessage, (int)0);
                    AutoRebaseProcess.this.openStagingView();
                    this.success = true;
                }
                catch (PartInitException e) {
                    EGerritCorePlugin.logError((String)e.getMessage());
                }
            } else if (this.status.getStatus() == RebaseResult.Status.UP_TO_DATE) {
                dialogMessage = Messages.AutoRebaseProcess_AlreadyUpToDate;
                MessageDialog.open((int)2, null, (String)Messages.AutoRebaseProcess_AlreadyUpToDateTitle, (String)dialogMessage, (int)0);
                this.success = false;
            } else {
                dialogMessage = Messages.AutoRebaseProcess_FailedRevertedBack;
                MessageDialog.open((int)2, null, (String)Messages.AutoRebaseProcess_AutoRebaseStarted, (String)dialogMessage, (int)0);
                this.success = false;
            }
        }
    }
}

