/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.synchronize.GitLocalResourceVariant;
import org.eclipse.egit.core.synchronize.GitResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitSyncCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.SessionResourceVariantByteStore;

class GitSourceResourceVariantTree
extends GitResourceVariantTree {
    public GitSourceResourceVariantTree(GitSyncCache cache, GitSynchronizeDataSet gsds) {
        super((ResourceVariantByteStore)new SessionResourceVariantByteStore(), cache, gsds);
    }

    @Override
    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        GitSynchronizeData data;
        if (resource != null && (data = this.gsds.getData(resource.getProject())) != null && data.shouldIncludeLocal()) {
            return new GitLocalResourceVariant(resource);
        }
        return super.fetchVariant(resource, depth, monitor);
    }

    @Override
    protected IResourceVariant[] fetchMembers(IResourceVariant variant, IProgressMonitor progress) throws TeamException {
        if (variant instanceof GitLocalResourceVariant && ((GitLocalResourceVariant)variant).getResource() instanceof IContainer) {
            IContainer resource = (IContainer)((GitLocalResourceVariant)variant).getResource();
            try {
                IResource[] children = resource.members();
                IResourceVariant[] result = new IResourceVariant[children.length];
                int i = 0;
                while (i < children.length) {
                    result[i] = new GitLocalResourceVariant(children[i]);
                    ++i;
                }
                return result;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return super.fetchMembers(variant, progress);
    }

    @Override
    protected ObjectId getObjectId(ThreeWayDiffEntry diffEntry) {
        return diffEntry.getLocalId().toObjectId();
    }

    @Override
    protected RevCommit getCommitId(GitSynchronizeData gsd) {
        return gsd.getSrcRevCommit();
    }
}

