/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.awtui;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.jgit.revplot.PlotCommitList;
import org.eclipse.jgit.revplot.PlotLane;

class SwingCommitList
extends PlotCommitList<SwingLane> {
    final Deque<Color> colors = new ArrayDeque<Color>();

    SwingCommitList() {
        this.repackColors();
    }

    private void repackColors() {
        this.colors.add(Color.green);
        this.colors.add(Color.blue);
        this.colors.add(Color.red);
        this.colors.add(Color.magenta);
        this.colors.add(Color.darkGray);
        this.colors.add(Color.yellow.darker());
        this.colors.add(Color.orange);
    }

    protected SwingLane createLane() {
        SwingLane lane = new SwingLane();
        if (this.colors.isEmpty()) {
            this.repackColors();
        }
        lane.color = this.colors.removeFirst();
        return lane;
    }

    protected void recycleLane(SwingLane lane) {
        this.colors.add(lane.color);
    }

    static class SwingLane
    extends PlotLane {
        private static final long serialVersionUID = 1L;
        Color color;

        SwingLane() {
        }
    }
}

