/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.riscv.core;

import java.io.File;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;

public class EnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean DEBUG_PATH = false;

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            return new IBuildEnvironmentVariable[]{path};
        }
        return new IBuildEnvironmentVariable[0];
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            PersistentPreferences commonPersistentPreferences = Activator.getInstance().getPersistentPreferences();
            String path = commonPersistentPreferences.getBuildToolsPath(project);
            IOption option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
            String toolchainName = (String)option.getValue();
            String toolchainPath = null;
            PersistentPreferences persistentPreferences = org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().getPersistentPreferences();
            toolchainPath = persistentPreferences.getToolchainPath(toolchainName, project);
            if (path.isEmpty()) {
                path = toolchainPath;
            } else if (!toolchainPath.isEmpty()) {
                path = String.valueOf(path) + EclipseUtils.getPathSeparator();
                path = String.valueOf(path) + toolchainPath;
            }
            if (!path.isEmpty()) {
                if (path.indexOf("${") >= 0) {
                    path = PathEnvironmentVariable.resolveMacros(path, configuration);
                }
                File sysroot = new File(path);
                if (DEBUG_PATH && org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
                    System.out.println("riscv.PathEnvironmentVariable.create() PATH=" + sysroot + " cfg=" + configuration + " prj=" + configuration.getManagedProject().getOwner().getName());
                }
                return new PathEnvironmentVariable(sysroot);
            }
            return null;
        }

        private static String resolveMacros(String str, IConfiguration configuration) {
            String result = str;
            try {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, (Object)configuration);
            }
            catch (CdtVariableException e) {
                org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.log((String)("resolveMacros " + e.getMessage()));
            }
            return result;
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getAbsolutePath();
        }
    }
}

