/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.core;

public abstract class ToolchainDefinition {
    protected long fUniqueId;
    protected String fName;
    protected String fPrefix;
    protected String fSuffix;
    protected String fArchitecture;
    protected String fCmdMake;
    protected String fCmdRm;
    protected String fCmdWinMake;
    protected String fCmdWinRm;
    protected String fCmdC;
    protected String fCmdCpp;
    protected String fCmdAr;
    protected String fCmdObjcopy;
    protected String fCmdObjdump;
    protected String fCmdSize;
    protected boolean fIsDeprecated;

    public ToolchainDefinition(String sName) {
        this.fName = sName;
        this.fUniqueId = Integer.toUnsignedLong(this.fName.hashCode());
        this.fPrefix = "";
        this.fSuffix = "";
        this.fArchitecture = "?";
        this.fCmdMake = "make";
        this.fCmdRm = "rm";
        this.fCmdC = "gcc";
        this.fCmdCpp = "g++";
        this.fCmdAr = "ar";
        this.fCmdObjcopy = "objcopy";
        this.fCmdObjdump = "objdump";
        this.fCmdSize = "size";
        this.fIsDeprecated = false;
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this(sName);
        this.fPrefix = sPrefix;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.setArchitecture(sArchitecture);
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public void setWin(String cmdMake, String cmdRm) {
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Deprecated
    public long getHash() {
        return this.fUniqueId;
    }

    @Deprecated
    public void setHash(int hash) {
        this.fUniqueId = Integer.toUnsignedLong(hash);
    }

    public String getId() {
        return Long.toString(this.fUniqueId);
    }

    public void setId(String id) {
        long val = Long.parseUnsignedLong(id);
        if (val != this.fUniqueId) {
            System.out.println("Toolchain '" + this.fName + "' has custom ID '" + id + "' instead of '" + this.fUniqueId + "'");
        }
        this.fUniqueId = val;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
    }

    public String getSuffix() {
        return this.fSuffix;
    }

    public void setSuffix(String suffix) {
        this.fSuffix = suffix;
    }

    public String getArchitecture() {
        return this.fArchitecture;
    }

    public void setArchitecture(String architecture) {
        this.fArchitecture = architecture;
    }

    public String getCmdMake() {
        return this.fCmdMake;
    }

    public void setCmdMake(String cmdMake) {
        this.fCmdMake = cmdMake;
    }

    public String getCmdRm() {
        return this.fCmdRm;
    }

    public void setCmdRm(String cmdRm) {
        this.fCmdRm = cmdRm;
    }

    public String getCmdWinMake() {
        return this.fCmdWinMake;
    }

    public void setCmdWinMake(String cmdWinMake) {
        this.fCmdWinMake = cmdWinMake;
    }

    public String getCmdWinRm() {
        return this.fCmdWinRm;
    }

    public void setCmdWinRm(String cmdWinRm) {
        this.fCmdWinRm = cmdWinRm;
    }

    public String getCmdC() {
        return this.fCmdC;
    }

    public void setCmdC(String cmdC) {
        this.fCmdC = cmdC;
    }

    public String getCmdCpp() {
        return this.fCmdCpp;
    }

    public void setCmdCpp(String cmdCpp) {
        this.fCmdCpp = cmdCpp;
    }

    public String getCmdAr() {
        return this.fCmdAr;
    }

    public void setCmdAr(String cmdAr) {
        this.fCmdAr = cmdAr;
    }

    public String getCmdObjcopy() {
        return this.fCmdObjcopy;
    }

    public void setCmdObjcopy(String cmdObjcopy) {
        this.fCmdObjcopy = cmdObjcopy;
    }

    public String getCmdObjdump() {
        return this.fCmdObjdump;
    }

    public void setCmdObjdump(String cmdObjdump) {
        this.fCmdObjdump = cmdObjdump;
    }

    public String getCmdSize() {
        return this.fCmdSize;
    }

    public void setCmdSize(String cmdSize) {
        this.fCmdSize = cmdSize;
    }

    public boolean isDeprecated() {
        return this.fIsDeprecated;
    }

    public void setIsDeprecated(boolean flag) {
        this.fIsDeprecated = flag;
    }

    public String getFullCmdC() {
        return String.valueOf(this.getPrefix()) + this.getCmdC() + this.getSuffix();
    }

    public String getFullName() {
        String cmd;
        String name = this.getName();
        String val = name.contains(cmd = this.getFullCmdC()) ? name : String.valueOf(name) + " (" + cmd + ")";
        if (this.fIsDeprecated) {
            val = String.valueOf(val) + " DEPRECATED";
        }
        return val;
    }
}

