/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class DateCellEditor
extends CellEditor
implements ECPCellEditor {
    private DateTime dateWidget;
    private final DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(2, 2);

    public DateCellEditor() {
    }

    public DateCellEditor(Composite parent) {
        super(parent);
    }

    public DateCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public IValueProperty getValueProperty() {
        return new WidgetValueProperty(){

            public Object getValueType() {
                return Date.class;
            }

            protected Object doGetValue(Object source) {
                return DateCellEditor.this.doGetValue();
            }

            protected void doSetValue(Object source, Object value) {
                DateCellEditor.this.doSetValue(value);
            }

            public IObservableValue observe(Object source) {
                if (source instanceof DateCellEditor) {
                    return this.observe((Widget)DateCellEditor.this.dateWidget);
                }
                return super.observe(source);
            }
        };
    }

    @Override
    public void instantiate(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) {
    }

    protected Control createControl(Composite parent) {
        this.dateWidget = new DateTime(parent, 32);
        this.dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_date");
        this.dateWidget.addKeyListener((KeyListener)new KeyAdapter(){
            private static final long serialVersionUID = 1L;

            public void keyPressed(KeyEvent e) {
                DateCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.dateWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetDefaultSelected(SelectionEvent event) {
                DateCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.dateWidget.addTraverseListener(new TraverseListener(){
            private static final long serialVersionUID = 1L;

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.dateWidget.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusLost(FocusEvent e) {
                DateCellEditor.this.focusLost();
            }
        });
        return this.dateWidget;
    }

    protected Object doGetValue() {
        Calendar selectedCalendarDate = Calendar.getInstance();
        selectedCalendarDate.set(1, this.dateWidget.getYear());
        selectedCalendarDate.set(2, this.dateWidget.getMonth());
        selectedCalendarDate.set(5, this.dateWidget.getDay());
        selectedCalendarDate.set(11, this.dateWidget.getHours());
        selectedCalendarDate.set(12, this.dateWidget.getMinutes());
        selectedCalendarDate.set(13, this.dateWidget.getSeconds());
        return selectedCalendarDate.getTime();
    }

    protected void doSetFocus() {
        this.dateWidget.setFocus();
    }

    protected void doSetValue(Object value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)value);
        this.dateWidget.setDate(cal.get(1), cal.get(2), cal.get(5));
        this.dateWidget.setTime(cal.get(11), cal.get(12), cal.get(13));
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        super.keyReleaseOccured(keyEvent);
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            MessageFormat.format(this.getErrorMessage(), newValue);
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    @Override
    public String getFormatedString(Object value) {
        Date cal = (Date)value;
        if (value == null) {
            return "";
        }
        return this.dateFormat.format(cal);
    }

    @Override
    public int getColumnWidthWeight() {
        return 75;
    }

    @Override
    public UpdateValueStrategy getTargetToModelStrategy() {
        return null;
    }

    @Override
    public UpdateValueStrategy getModelToTargetStrategy() {
        return null;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.dateWidget != null) {
            this.dateWidget.setEnabled(editable);
        }
    }
}

