/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import java.util.Iterator;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;

public class XMLDateControlRendererTester
implements ECPRendererTester {
    private static final String XML_TYPE_DATE = "http://www.eclipse.org/emf/2003/XMLType#date";
    private static final String BASE_TYPE = "baseType";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_NAME = "name";
    private static final String EXTENDED_META_DATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";

    @Override
    public int isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        if (!VControl.class.isInstance(vElement)) {
            return -1;
        }
        VControl control = (VControl)vElement;
        EStructuralFeature.Setting setting = this.getSetting(control);
        if (setting == null) {
            return -1;
        }
        EStructuralFeature feature = setting.getEStructuralFeature();
        if (feature.isMany()) {
            return -1;
        }
        if (EReference.class.isInstance(feature)) {
            return -1;
        }
        EDataType eAttributeType = ((EAttribute)EAttribute.class.cast(feature)).getEAttributeType();
        if (eAttributeType == XMLTypePackage.eINSTANCE.getDate()) {
            return this.getPriority();
        }
        Class instanceClass = eAttributeType.getInstanceClass();
        if (instanceClass == null || !this.getSupportedClassType().isAssignableFrom(instanceClass)) {
            return -1;
        }
        if (this.checkFeatureETypeAnnotations((EList<EAnnotation>)feature.getEType().getEAnnotations())) {
            return this.getPriority();
        }
        return -1;
    }

    private EStructuralFeature.Setting getSetting(VControl control) {
        Iterator iterator = control.getDomainModelReference().getIterator();
        int count = 0;
        EStructuralFeature.Setting setting = null;
        while (iterator.hasNext()) {
            ++count;
            setting = (EStructuralFeature.Setting)iterator.next();
        }
        if (count != 1) {
            return null;
        }
        return setting;
    }

    private int getPriority() {
        return 3;
    }

    private Class<?> getSupportedClassType() {
        return XMLGregorianCalendar.class;
    }

    private boolean checkFeatureETypeAnnotations(EList<EAnnotation> eAnnotations) {
        for (EAnnotation annotation : eAnnotations) {
            if (!annotation.getSource().equals(EXTENDED_META_DATA)) continue;
            if (annotation.getDetails().containsKey((Object)TYPE_NAME) && ((String)annotation.getDetails().get((Object)TYPE_NAME)).equals(TYPE_DATE)) {
                return true;
            }
            if (!annotation.getDetails().containsKey((Object)BASE_TYPE) || !((String)annotation.getDetails().get((Object)BASE_TYPE)).equals(XML_TYPE_DATE)) continue;
            return true;
        }
        return false;
    }
}

