/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.VersionVerifier;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ClientVersionOutOfDateException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESClientVersionInfoImpl;
import org.eclipse.emf.emfstore.server.auth.ESUserVerifier;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;

public abstract class PasswordVerifier
implements ESUserVerifier {
    private final String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
    private final String superuserpw = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser.password", "super");

    protected AuthenticationInformation createAuthenticationInfo() {
        AuthenticationInformation authenticationInformation = ModelFactory.eINSTANCE.createAuthenticationInformation();
        authenticationInformation.setSessionId(ModelFactory.eINSTANCE.createSessionId());
        return authenticationInformation;
    }

    protected String preparePassword(String password) throws ServerKeyStoreException {
        return ServerKeyStoreManager.getInstance().decrypt(password);
    }

    protected boolean verifySuperUser(String username, String password) {
        return username.equals(this.superuser) && password.equals(this.superuserpw);
    }

    protected abstract boolean verifyPassword(String var1, String var2) throws AccessControlException;

    protected void checkClientVersion(ESClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        VersionVerifier.verify(ServerConfiguration.getSplittedProperty("emfstore.acceptedversions"), (ClientVersionInfo)((ESClientVersionInfoImpl)ESClientVersionInfoImpl.class.cast(clientVersionInfo)).toInternalAPI());
    }
}

