/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.accesscontrol;

import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;

public class AccessControlHelper {
    private ACUser user;

    public AccessControlHelper(Usersession usersession) {
        this.user = usersession.getACUser();
    }

    public void checkReadAccess(ProjectId projectId) throws AccessControlException {
        for (Role role : this.user.getRoles()) {
            if (!role.canRead(projectId, null)) continue;
            return;
        }
        throw new AccessControlException();
    }

    public void checkWriteAccess(ProjectId projectId) throws AccessControlException {
        for (Role role : this.user.getRoles()) {
            if (!role.canDelete(projectId, null) && !role.canCreate(projectId, null) && !role.canModify(projectId, null)) continue;
            return;
        }
        throw new AccessControlException();
    }

    public void checkProjectAdminAccess(ProjectId projectId) throws AccessControlException {
        for (Role role : this.user.getRoles()) {
            if (!role.canAdministrate(projectId)) continue;
            return;
        }
        throw new AccessControlException();
    }

    public void checkServerAdminAccess() throws AccessControlException {
        for (Role role : this.user.getRoles()) {
            if (!(role instanceof ServerAdmin)) continue;
            return;
        }
        throw new AccessControlException();
    }
}

