/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.persistence;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithSharedProject;
import org.eclipse.emf.emfstore.client.test.common.dsl.Add;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourcePersisterTest
extends ESTestWithSharedProject {
    private static final String ANOTHER_PROJECT = "AnotherProject";
    private static IProgressMonitor npm = new NullProgressMonitor();
    private Resource anotherProjectResource;

    @BeforeClass
    public static void beforeClass() {
        ResourcePersisterTest.startEMFStore();
    }

    @AfterClass
    public static void afterClass() {
        ResourcePersisterTest.stopEMFStore();
    }

    public void before() {
        super.before();
        try {
            ESRemoteProject remoteProject = this.getServer().createRemoteProject(this.getUsersession(), ANOTHER_PROJECT, ResourcePersisterTest.nullProgressMonitor());
            ESLocalProject anotherLocalProject = remoteProject.checkout(ANOTHER_PROJECT, ResourcePersisterTest.nullProgressMonitor());
            ProjectSpace internalAPI = (ProjectSpace)((ESLocalProjectImpl)anotherLocalProject).toInternalAPI();
            this.anotherProjectResource = internalAPI.eResource();
        }
        catch (ESException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void saveOnlyAffectedProject() throws ESException {
        long timeStamp = this.anotherProjectResource.getTimeStamp();
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)Create.player());
        this.getLocalProject().commit((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)this.anotherProjectResource.getTimeStamp(), (long)timeStamp);
    }

    private static IProgressMonitor nullProgressMonitor() {
        return npm;
    }
}

