/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;

public class MethodInvocation {
    private EmfStoreMethod.MethodId methodId;
    private Object[] allParameters;
    private SessionId sessionId;
    private String methodName;

    public MethodInvocation(String methodName, Object[] params) throws InvalidInputException {
        this.sessionId = (SessionId)params[0];
        if (this.sessionId == null) {
            throw new InvalidInputException("operations requires session id");
        }
        this.allParameters = params;
        this.methodId = EmfStoreMethod.MethodId.valueOf(methodName.toUpperCase());
        this.methodName = methodName;
    }

    public EmfStoreMethod.MethodId getType() {
        return this.methodId;
    }

    public Object[] getParameters() {
        if (this.allParameters.length > 1) {
            Object[] result = new Object[this.allParameters.length - 1];
            int i = 1;
            while (i < this.allParameters.length) {
                result[i - 1] = this.allParameters[i];
                ++i;
            }
            return result;
        }
        return new Object[0];
    }

    public Object[] getAllParameters() {
        return this.allParameters;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

