/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HeadVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;

public final class Versions {
    private Versions() {
    }

    public static HeadVersionSpec createHEAD() {
        return VersioningFactory.eINSTANCE.createHeadVersionSpec();
    }

    public static HeadVersionSpec createHEAD(String branch) {
        HeadVersionSpec headVersionSpec = VersioningFactory.eINSTANCE.createHeadVersionSpec();
        headVersionSpec.setBranch(branch);
        return headVersionSpec;
    }

    public static HeadVersionSpec createHEAD(VersionSpec versionSpec) {
        if (versionSpec == null) {
            return Versions.createHEAD();
        }
        return Versions.createHEAD(versionSpec.getBranch());
    }

    public static PrimaryVersionSpec createPRIMARY(String branch, int index) {
        PrimaryVersionSpec spec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        spec.setIdentifier(index);
        spec.setBranch(branch);
        return spec;
    }

    public static PrimaryVersionSpec createPRIMARY(VersionSpec versionSpec, int index) {
        return Versions.createPRIMARY(versionSpec.getBranch(), index);
    }

    public static PrimaryVersionSpec createPRIMARY(int i) {
        return Versions.createPRIMARY("trunk", i);
    }

    public static BranchVersionSpec createBRANCH(String value) {
        BranchVersionSpec branchSpec = VersioningFactory.eINSTANCE.createBranchVersionSpec();
        branchSpec.setBranch(value);
        return branchSpec;
    }

    public static BranchVersionSpec createBRANCH(VersionSpec spec) {
        return Versions.createBRANCH(spec.getBranch());
    }

    public static AncestorVersionSpec createANCESTOR(PrimaryVersionSpec source, PrimaryVersionSpec target) {
        AncestorVersionSpec ancestor = VersioningFactory.eINSTANCE.createAncestorVersionSpec();
        ancestor.setBranch(source.getBranch());
        ancestor.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)source));
        ancestor.setTarget((PrimaryVersionSpec)ModelUtil.clone((EObject)target));
        return ancestor;
    }

    public static boolean isSameBranch(VersionSpec spec1, VersionSpec spec2) {
        if (spec1 == null || spec2 == null) {
            return false;
        }
        return spec1.getBranch() != null && spec1.getBranch().equals(spec2.getBranch());
    }

    public static TagVersionSpec createTAG(String tag, String branch) {
        TagVersionSpec tagSpec = VersioningFactory.eINSTANCE.createTagVersionSpec();
        tagSpec.setBranch(branch);
        tagSpec.setName(tag);
        return tagSpec;
    }

    public static PagedUpdateVersionSpec createPAGEDUPDATE(PrimaryVersionSpec baseVersion, int maxChanges) {
        PagedUpdateVersionSpec versionSpec = VersioningFactory.eINSTANCE.createPagedUpdateVersionSpec();
        versionSpec.setBaseVersionSpec(baseVersion);
        versionSpec.setMaxChanges(maxChanges);
        return versionSpec;
    }
}

