/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.historybrowsercomparator;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonEditorInput;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.emfstore.client.ui.ESCompare;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EMFCompareComparator
implements ESCompare {
    private Comparison comparison;
    private EObject eObject1;
    private EObject eObject2;

    public void compare(EObject e1, EObject e2) {
        if (!(e1 instanceof Project) || !(e2 instanceof Project)) {
            throw new IllegalArgumentException("The objects have to be Projects!");
        }
        this.eObject1 = e1;
        this.eObject2 = e2;
        this.comparison = EMFCompare.builder().build().compare(this.twoWayScope(this.eObject1, this.eObject2));
        this.comparison.setDiagnostic((Diagnostic)new BasicDiagnostic());
    }

    private IComparisonScope twoWayScope(EObject e1, EObject e2) {
        return new DefaultComparisonScope((Notifier)e1, (Notifier)e2, null);
    }

    public void display() {
        if (this.comparison.getDifferences().isEmpty()) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openInformation((Shell)shell, (String)"No changes", (String)"There are no changes in the comparison.");
            return;
        }
        ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)this.eObject1, (Notifier)this.eObject2, null);
        ComposedAdapterFactory.Descriptor.Registry adapterFactoryRegistry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(adapterFactoryRegistry);
        EMFCompareConfiguration config = this.createDefaultCompareConfiguration();
        ComparisonEditorInput input = new ComparisonEditorInput(config, this.comparison, editingDomain, (AdapterFactory)adapterFactory);
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    private EMFCompareConfiguration createDefaultCompareConfiguration() {
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftEditable(false);
        config.setRightEditable(false);
        return new EMFCompareConfiguration(config);
    }
}

