/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIUpdateProjectController;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.query.ESHistoryQuery;
import org.eclipse.emf.emfstore.server.model.query.ESRangeQuery;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUpdateProjectToVersionController
extends AbstractEMFStoreUIController<ESPrimaryVersionSpec> {
    private final ESLocalProject projectSpace;

    public UIUpdateProjectToVersionController(Shell shell, ESLocalProject localProject) {
        super(shell, true, true);
        this.projectSpace = localProject;
    }

    @Override
    public ESPrimaryVersionSpec doRun(IProgressMonitor monitor) throws ESException {
        ESRangeQuery query = ESHistoryQuery.FACTORY.rangeQuery(this.projectSpace.getBaseVersion(), 20, 0, false, false, false, false);
        List historyInfo = this.projectSpace.getHistoryInfos((ESHistoryQuery)query, (IProgressMonitor)new NullProgressMonitor());
        Iterator iter = historyInfo.iterator();
        while (iter.hasNext()) {
            if (!this.projectSpace.getBaseVersion().equals(((ESHistoryInfo)iter.next()).getPrimarySpec())) continue;
            iter.remove();
            break;
        }
        if (historyInfo.size() == 0) {
            return RunInUI.WithException.runWithResult(new Callable<ESPrimaryVersionSpec>(){

                @Override
                public ESPrimaryVersionSpec call() throws Exception {
                    return (ESPrimaryVersionSpec)new UIUpdateProjectController(UIUpdateProjectToVersionController.this.getShell(), UIUpdateProjectToVersionController.this.projectSpace, (ESVersionSpec)ESVersionSpec.FACTORY.createHEAD((ESVersionSpec)UIUpdateProjectToVersionController.this.projectSpace.getBaseVersion())).execute();
                }
            });
        }
        final ListDialog listDialog = this.createDialog(historyInfo);
        Integer result = RunInUI.runWithResult(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return listDialog.open();
            }
        });
        if (result == 0) {
            Object[] selection = listDialog.getResult();
            final ESHistoryInfo info = (ESHistoryInfo)selection[0];
            return RunInUI.WithException.runWithResult(new Callable<ESPrimaryVersionSpec>(){

                @Override
                public ESPrimaryVersionSpec call() throws Exception {
                    UIUpdateProjectController controller = new UIUpdateProjectController(UIUpdateProjectToVersionController.this.getShell(), UIUpdateProjectToVersionController.this.projectSpace, (ESVersionSpec)ESVersionSpec.FACTORY.createPRIMARY(info.getPrimarySpec().getIdentifier()));
                    return (ESPrimaryVersionSpec)controller.execute();
                }
            });
        }
        return null;
    }

    private ListDialog createDialog(List<ESHistoryInfo> historyInfo) {
        ListDialog listDialog = new ListDialog(this.getShell());
        listDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ESHistoryInfo historyInfo = (ESHistoryInfo)element;
                StringBuilder sb = new StringBuilder(Messages.UIUpdateProjectToVersionController_Version);
                sb.append(Integer.toString(historyInfo.getPrimarySpec().getIdentifier()));
                sb.append("  -  ");
                sb.append(historyInfo.getLogMessage().getMessage());
                return sb.toString();
            }
        });
        listDialog.setInput(historyInfo);
        listDialog.setTitle(Messages.UIUpdateProjectToVersionController_SelectVersion_Title);
        listDialog.setMessage(Messages.UIUpdateProjectToVersionController_SelectVersion_Message);
        listDialog.setInitialSelections(new Object[]{historyInfo.get(0)});
        return listDialog;
    }
}

