/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.BranchSelectionDialog;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTagDialog
extends BranchSelectionDialog {
    private Field tagNameField;
    private String tagName;

    public CreateTagDialog(Shell parentShell, List<BranchInfo> branches) {
        super(parentShell, branches);
    }

    @Override
    protected void addCreationField(Composite container) {
        this.tagNameField = this.createField(container, Messages.UIAddTagController_TagNameLabel, Messages.UIAddTagController_TagNameTextDefault);
    }

    private Field createField(Composite container, String labelText, String defaultText) {
        Field field = new Field(container);
        field.setLabelText(labelText);
        field.setDefaultText(defaultText);
        field.setLayoutData(new GridData(4, 0x1000000, true, false));
        return field;
    }

    @Override
    protected void okPressed() {
        this.tagName = this.tagNameField.getText();
        super.okPressed();
    }

    @Override
    protected void setHeaderTexts() {
        this.getShell().setText("Create Tag");
        this.setTitle("Create tag for project");
        this.setMessage("Please specify a tag name and select the branch you want to create a tag for");
    }

    public String getTagName() {
        return this.tagName;
    }

    private class Field
    extends Composite {
        private final Label label;
        private final Text text;

        public Field(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.label = new Label((Composite)this, 0);
            this.text = new Text((Composite)this, 2048);
            this.label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        public String getText() {
            return this.text.getText();
        }

        public void setDefaultText(String defaultText) {
            this.text.setText(defaultText);
        }

        public void setLabelText(String labelText) {
            this.label.setText(labelText);
        }
    }
}

