/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.configuration;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.client.provider.ESClientVersionProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.osgi.framework.Bundle;

public class VersioningInfo {
    private static final String CLIENT_NAME = "emfstore eclipse client";

    public ClientVersionInfo getClientVersion() {
        ClientVersionInfo clientVersionInfo = ModelFactory.eINSTANCE.createClientVersionInfo();
        clientVersionInfo.setName(CLIENT_NAME);
        ESExtensionElement version = new ESExtensionPoint("org.eclipse.emf.emfstore.client.clientVersion").setThrowException(false).getFirst();
        if (version != null) {
            ESClientVersionProvider versionProvider = (ESClientVersionProvider)version.getClass("class", ESClientVersionProvider.class);
            clientVersionInfo.setName(versionProvider.getName());
            clientVersionInfo.setVersion(versionProvider.getVersion());
            return clientVersionInfo;
        }
        Bundle emfStoreBundle = Platform.getBundle((String)"org.eclipse.emf.emfstore.client");
        String versionId = (String)emfStoreBundle.getHeaders().get("Bundle-Version");
        clientVersionInfo.setVersion(versionId);
        return clientVersionInfo;
    }

    public boolean isReleaseVersion() {
        return !this.isInternalReleaseVersion() && !this.getClientVersion().getVersion().endsWith("qualifier");
    }

    public boolean isInternalReleaseVersion() {
        return this.getClientVersion().getVersion().endsWith("internal");
    }

    public boolean isDeveloperVersion() {
        return !this.isReleaseVersion() && !this.isInternalReleaseVersion();
    }
}

